# RepViT
RepViT在iPhone 12上以1ms的延迟实现了超过80%的top-1准确率，本算法基于RepViT进一步优化后准确率超过82%。
## 论文
`RepViT: Revisiting Mobile CNN From ViT Perspective`
- https://arxiv.org/pdf/2307.09283

## 模型结构
RepViT以MobileNetV3-L为base进行算法优化，从一个标准的轻量级CNN开始，结合轻量级vit的架构设计，使得既具备CNN小计算量又具备vit架构的优势，本算法进一步解决原算法在空间、全局注意力机制等方面的不足，获得vit在attention方面的优势。
<div align=center>
    <img src="./doc/structure.png"/>
</div>

## 算法原理
RepViT与其它图像分类算法一样，将图片数据送入模型后，依次通过预处理、特征提取，然后经过全连接层预测出图片类别。
<div align=center>
    <img src="./doc/algorithm.png"/>
</div>

## 环境配置
```
mv repvit-optimize_pytorch RepViT # 去框架名后缀
```

### Docker（方法一）
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
# <your IMAGE ID>为以上拉取的docker的镜像ID替换，本镜像为：c85ed27005f2
docker run -it --shm-size=32G -v $PWD/RepViT:/home/RepViT -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name repvit <your IMAGE ID> bash
cd /home/RepViT
pip install -r requirements.txt # requirements.txt
```
### Dockerfile（方法二）
```
cd RepViT/docker
docker build --no-cache -t repvit:latest .
docker run --shm-size=32G --name repvit -v /opt/hyhal:/opt/hyhal:ro --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video -v $PWD/../../RepViT:/home/RepViT -it repvit bash
# 若遇到Dockerfile启动的方式安装环境需要长时间等待，可注释掉里面的pip安装，启动容器后再安装python库：pip install -r requirements.txt。
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
- https://developer.hpccube.com/tool/
```
DTK驱动:dtk24.04
python:python3.10
torch:2.1.0
torchvision:0.16.0
onnxruntime:1.15.0
```

`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应。`

2、其它非特殊库参照requirements.txt安装
```
pip install -r requirements.txt # requirements.txt
```

## 数据集
`cifar100`
- http://www.cs.toronto.edu/~kriz/cifar-100-python.tar.gz

下载解压即可使用，文件大小约161Mb，项目中已包含[`cifar100`](./cifar100.zip)，训练数据目录结构如下：
```
cifar100/cifar-100-python
            ├── train
            ├── test
            ├── meta
            └── file.txt~
```

## 训练
### 单机多卡
```
# 以数据集CIFAR为基础进行算法效果提升
# 关闭wandb用wandb disabled
python -m torch.distributed.launch --nproc_per_node=4 --master_port 12356 --use_env main.py --model repvit_m0_9 --data-path ./cifar100 --data-set CIFAR --epochs 300 --dist-eval --distillation-type none
```
更多资料可参考源项目的[`README_origin`](./README_origin.md)

## result
### 精度
数据集：cifar100，max epoch为300，推理框架：pytorch，device：DCU K100。

|    算法     | top-1 acc | params  |
|:---------:|:---------:|:-------:|
| RepViT  |   81.84%   | 4757060 |
| RepViT-optimize |   82.91%   | 4843172 |

## 应用场景
### 算法类别
`图像分类`
### 热点应用行业
`制造,电商,医疗,能源,教育`
## 源码仓库及问题反馈
- http://developer.hpccube.com/codes/modelzoo/repvit-optimize_pytorch.git
## 参考资料
- https://github.com/THU-MIG/RepViT.git

