#!/bin/bash
# NCCL相关的DEBUG信息显示
export NCCL_DEBUG=INFO
export NCCL_NET_PLUGIN=none

export HSA_FORCE_FINE_GRAIN_PCIE=1
export USE_MIOPEN_BATCHNORM=1

export NCCL_P2P_LEVEL=5
export WORLD_SIZE=$OMPI_COMM_WORLD_SIZE
export NCCL_PLUGIN_P2P=ucx
export NCCL_SHM_DISABLE=1
export NCCL_IB_DISABLE=0 #不适用ib
export NCCL_IB_HCA=mlx5_0
export NCCL_CROSS_NIC=1
export RCCL_NCHANNELS=4
export MASTER_ADDR=$dist_url
export MASTER_PORT=4321
export LOCAL_RANK=$OMPI_COMM_WORLD_LOCAL_RANK

lrank=$OMPI_COMM_WORLD_LOCAL_RANK

CONFIG="options/train_realesrnet_x4plus.yml"
APP="python3 -u realesrgan/train.py -opt $CONFIG --auto_resume"

case $(expr $lrank % 4) in
[0])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_0:1
  export UCX_IB_PCI_BW=mlx5_0:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_1:1
  export UCX_IB_PCI_BW=mlx5_1:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=1 --membind=1 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_2:1
  export UCX_IB_PCI_BW=mlx5_2:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=2 --membind=2 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=0,1,2,3
  export UCX_NET_DEVICES=mlx5_3:1
  export UCX_IB_PCI_BW=mlx5_3:50Gbs
  NCCL_SOCKET_IFNAME=ib0 numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac
