# ReaderLM
## 论文
[ReaderLM](https://arxiv.org/pdf/2503.01151)

## 模型简介
ReaderLM-v2是一款拥有15亿参数的语言模型，能够将原始HTML转换为格式优美的Markdown或JSON，具备卓越的准确性和优化的长上下文处理能力。该模型支持多语言（共29种），专门适用于HTML解析、格式转换及文本提取等任务。  
ReaderLM-v2 相较于前代模型实现显著突破，其核心改进包括：
- 更优的Markdown生成能力：依托新型训练范式与更高质量的训练数据，该模型在生成代码块、嵌套列表、表格及LaTeX公式等复杂元素时表现卓越。  
- JSON格式输出功能：支持基于预设架构的HTML直接转JSON，无需经过中间Markdown转换环节。  
- 长上下文处理增强：支持输入输出总计512K token的处理长度，在长文本内容上性能表现显著提升。  
- 多语言适配扩展：全面支持29种语言，拓展全球化应用场景。  
- 生成稳定性强化：通过训练过程中的对比损失机制，有效缓解长序列生成后的退化问题。
## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

推荐使用镜像:image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name ReaderLM --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve  jinaai/ReaderLM-v2   --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1 --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8000/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "jinaai/ReaderLM-v2",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| ReaderLM-v2 | 1.5B | K100AI | 1 | [下载地址](https://huggingface.co/jinaai/ReaderLM-v2) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/readerlm_vllm

## 参考资料
- https://jina.ai/news/readerlm-v2-frontier-small-language-model-for-html-to-markdown-and-json/
- https://huggingface.co/jinaai/ReaderLM-v2
