# Qwen
## 论文

`Qwen-VL: A Frontier Large Vision-Language Model with Versatile Abilities`

https://arxiv.org/pdf/2308.12966.pdf

## 模型结构

通义千问（Qwen） 是阿里云研发的通义千问大模型系列的70/140亿参数规模的模型。Qwen是基于Transformer的大语言模型, 在超大规模的预训练数据上进行训练得到。预训练数据类型多样，覆盖广泛，包括大量网络文本、专业书籍、代码等。同时，在Qwen-7B的基础上，使用对齐机制打造了基于大语言模型的AI助手Qwen-7B-Chat。

本项目主要针对Qwen-Chat在DCU平台的推理性能优化，达到DCU平台较快的对话效果。

![qwen](docs/transformer.jpg)


## 算法原理

Qwen的构建采用了类似LLaMA的架构。与标准transformer的主要差异有：1）使用非连接嵌入、2）使用旋转位置嵌入、3）在注意力中除了QKV外不使用偏置、4）使用RMSNorm代替LayerNorm、5）使用SwiGLU代替ReLU、以及6）采用快速注意力来加速训练。该模型共有32层，嵌入维度为4096，注意力头数为32。

![qwen](docs/qwen.png)

## 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --network=host --name=qwen_lmdeploy --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=1024G --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 -v /opt/hyhal:/opt/hyhal:ro -v <Host Path>:<Container Path> <Image ID> /bin/bash

```
镜像版本依赖：
* DTK驱动：24.04.1
* Pytorch: 2.1.0
* python: python3.10

## 数据集
无

## 推理
### 源码编译安装
```bash
# 若使用光源的镜像，可以不用源码编译，镜像里面安装好了lmdeploy，可跳过源码编译安装
# 获取源码，编译并安装
git clone -b v1.4 http://developer.hpccube.com/codes/modelzoo/Qwen_lmdeploy.git
cd qwen_lmdeploy
git submodule init && git submodule update
cd lmdeploy
mkdir build && cd build
sh ../generate.sh
make -j 32
make install
cd .. && python3 setup.py install
```

### 模型下载

SCNet模型下载

[Qwen-7B-chat](http://113.200.138.88:18080/aimodels/Qwen-7B-Chat)

[Qwen-14B-chat](http://113.200.138.88:18080/aimodels/Qwen-14B-Chat)

[Qwen-72B-Chat](http://113.200.138.88:18080/aimodels/Qwen-72B-Chat)

### 运行前

```bash
#step 1
cd lmdeploy
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
#step 2
source /opt/dtk/cuda/env.sh
```


### 运行 Qwen-7B-chat
```bash
# bash界面运行
lmdeploy chat turbomind path_to_Qwen-7B-chat    # 输入问题后执行2次回车进行推理

# 服务器网页端运行
# <server-name> gradio服务器的ip地址
# <server-port> gradio服务器的ip的端口
# <tp> 用于张量并行的GPU数量应该是2^n （和模型转换的时候保持一致）
# <backend> 后端支持turbomind/pytorch
lmdeploy serve gradio path_to_Qwen-7B-chat --server-name {ip} --server-port {port} --backend turbomind --tp 1
在网页上输入{ip}:{port}即可进行对话
```
### 运行 Qwen-14B-chat
```bash
# bash界面运行
lmdeploy chat turbomind path_to_Qwen-14B-chat --tp 2

# 服务器网页端运行
# 在bash端运行：
lmdeploy serve gradio path_to_Qwen-14B-chat --server-name {ip} --server-port {port} --backend turbomind --tp 2
在网页上输入{ip}:{port}即可进行对话
```
### 运行 Qwen-72B-chat

```bash
# bash界面运行
lmdeploy chat turbomind path_to_Qwen-72B-chat --tp 8

# 服务器网页端运行
#在bash端运行：
lmdeploy serve gradio path_to_Qwen-72B-chat --server-name {ip} --server-port {port} --backend turbomind --tp 8
在网页上输入{ip}:{port}即可进行对话
```

### api-server方式运行实例

启动server：

```bash
# --tp: 在 tensor parallel时，使用的GPU数量
lmdeploy serve api_server path_to_Qwen-72B-chat --server-name {ip} --server-port {port} --tp 8
```

浏览器上打开 `http://{server-name}:{server-port}`，即可访问 swagger，查阅 RESTful API 的详细信息。

可以用命令行，在控制台与 server 通信（在新启的命令行页面下执行）：

```bash
# restful_api_url 就是 api_server 产生的，即上述启动server的http://{server-name}:{server-port}
lmdeploy serve api_client restful_api_url
```

或者，启动 gradio，在 webui 的聊天对话框中，与服务交流：

```bash
# restful_api_url 就是 api_server 产生的，比如 http://localhost:23333
# server-name 和 server-port 是用来提供 gradio ui 访问服务的
# 例子: lmdeploy serve gradio http://localhost:23333 --server-name localhost --server-port 6006
lmdeploy serve gradio restful_api_url --server-name {ip} --server-port {port}
```

**需要保证'{server-name}:{server-port}'在外部浏览器中的可访问性**

关于 RESTful API的详细介绍，请参考[这份](https://developer.hpccube.com/codes/aicomponent/lmdeploy/-/blob/dtk23.10-v0.1.0/docs/zh_cn/restful_api.md)文档。

## result

![qwen推理](docs/qwen推理.gif)

### 精度

无

## 应用场景

### 算法类别

`对话问答`


### 热点应用行业

`医疗,科研,金融,教育`


## 源码仓库及问题反馈
https://developer.hpccube.com/codes/modelzoo/qwen_lmdeploy

## 参考资料
https://github.com/InternLM/LMDeploy
