# 模型简介

**Qwen3-Coder-Next** 是 Qwen 团队最新发布的开源（Open-weight）语言模型，专为**代码智能体（Coding Agents）和本地开发**场景设计 。该模型采用了**稀疏混合专家（MoE）**架构，在保持极高推理效率的同时，展现出了强大的代码推理和软件工程能力。其核心设计理念是通过大规模的“智能体训练”（Agentic Training），在较小的激活参数下实现顶尖的性能 。核心技术特点:

**训练理念与技术：** 其核心设计理念是通过大规模的“智能体训练”（Agentic Training），在较小的激活参数下实现顶尖的性能 。团队构建了名为 MegaFlow 的基础设施，通过挖掘 GitHub PR 并结合 Docker 容器，合成了数百万个可执行、可验证的真实软件工程任务 。同时，引入了基于执行反馈的强化学习（Reinforcement Learning），使模型不仅学习代码生成，还能通过环境反馈（如单元测试、运行时错误）来优化多步推理、工具使用和自我修正能力 。

**核心能力与工具支持：** 不同于传统的代码补全模型，Qwen3-Coder-Next 专注于解决长周期的软件工程任务、复杂的指令跟随以及与执行环境的交互 。训练阶段支持 262,144 token 的上下文窗口，能够处理整个代码仓库（Repository-level）的信息，理解跨文件依赖，适合解决复杂的 Bug 修复和功能开发任务 。此外，模型在训练中接触了多种工具调用格式（JSON, XML, Pythonic 等），能够适应不同的 IDE 和 Agent 框架（如 OpenHands, SWE-Agent），具备极强的格式鲁棒性 。

**基准测试表现：** 尽管激活参数仅为 3B，Qwen3-Coder-Next 在多个权威基准测试中表现出了越级挑战的能力。在 SWE-Bench Verified 中，于 SWE-Agent 框架下达到 70.6%，在 OpenHands 下达到 71.3%，性能与 32B-671B 参数级别的开源模型（如 DeepSeek-V3.2, GLM-4.7）相当，甚至在某些指标上超越了闭源模型 。在更具挑战性的长周期基准测试 SWE-Bench Pro 中，得分为 44.3%，优于 DeepSeek-V3.2 (40.9%) 和 GLM-4.7 (40.6%) 。此外，在 Python、Java、C++ 等多语言编程任务以及数学推理（如 AIME 2025）上均表现优异，证明了其广泛的泛化能力 。

<div align=center>
    <img src="./doc/1.png"/>
</div>

## 环境依赖

|     软件     |                       版本                        |
| :----------: | :-----------------------------------------------: |
|     DTK      |                      25.04.2                      |
|    python    |                      3.10.12                      |
| transformers |                      4.57.1                       |
|    torch     |              2.5.1+das.opt1.dtk25042              |
|  accelerate  |                      1.11.0                       |
| torchvision  |             0.20.1+das.opt1.dtk25042              |
|  flash_attn  |              2.6.1+das.opt1.dtk2604.20260131.g4edd8bf9               |
|     vllm     | 0.11.0+das.opt1.rc2.dtk2604.20260128.g0bf89b0c |

推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk26.04-0130-py3.10-20260202

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name qwen3 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226
```

更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

## vllm

#### 单机推理

```bash
## serve启动
export HF_HUB_OFFLINE=1
export TRANSFORMERS_OFFLINE=1
vllm serve Qwen/Qwen3-Coder-Next \
    --served-model-name Qwen3-Coder-Next \
    --dtype bfloat16 \
    --trust-remote-code \
    --tensor-parallel-size 4 \
    --gpu-memory-utilization 0.95 \
    --max-model-len 8192 \
    --port 8000

## client访问
curl http://localhost:8000/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "Qwen3-Coder-Next",
        "messages": [
            {
                "role": "user",
                "content": "Hello, how to user vllm?"
            }
        ]
    }'
```

## 效果展示

<div align=center>
    <img src="./doc/2.png"/>
</div>
### 精度

`DCU与GPU精度一致，推理框架：vllm。`

## 预训练权重[Qwen3-Coder-Next](https://huggingface.co/Qwen/Qwen3-Coder-Next)

|     **模型名称**     | **权重大小** |  **DCU型号**   | **最低卡数需求** |                         **下载地址**                         |
| :------------------: | :----------: | :------------: | :--------------: | :----------------------------------------------------------: |
| **Qwen3-Coder-Next** |     80B      | K100AI、BW1000 |        4         | [Qwen3-Coder-Next](https://huggingface.co/Qwen/Qwen3-VL-2B-Instruct) |




## 源码仓库及问题反馈

- https://developer.sourcefind.cn/codes/modelzoo/qwen3_coder_next_vllm

## 参考资料

- https://github.com/QwenLM/Qwen3-Coder
