# Qwen3-VL
## 论文
[Qwen3-VL Technical Report](https://arxiv.org/pdf/2511.21631)

## 模型简介
Qwen3-VL——迄今为止 Qwen 系列中最强大的视觉语言模型。
这一代产品在各方面都进行了全面升级：更出色的文本理解和生成能力、更深入的视觉感知和推理能力、更长的上下文长度、更强大的空间和视频动态理解能力以及更强大的代理交互能力。
提供从边缘到云端可扩展的密集型和 MoE 架构，以及可灵活按需部署的指导型和推理增强型思维型版本。
主要改进：
- 视觉代理：操作 PC/移动 GUI——识别元素、理解功能、调用工具、完成任务。
Visual Coding Boost：从图像/视频生成 Draw.io/HTML/CSS/JS。
- 高级空间感知：判断物体位置、视角和遮挡；提供更强的 2D 基础，并为空间推理和具身人工智能实现 3D 基础。
- 长上下文和视频理解：原生支持 256K 上下文，可扩展至 1M；能够处理书籍和数小时的视频，并具有完全回忆和二级索引功能。
- 增强型多模态推理能力：在 STEM/数学领域表现出色——因果分析和基于逻辑、证据的答案。
- 升级的视觉识别：更广泛、更高质量的预训练能够“识别一切”——名人、动漫、产品、地标、动植物等。
- 扩展的 OCR：支持 32 种语言（从 10 种增加到 32 种）；在弱光、模糊和倾斜条件下表现更佳；对罕见/古代字符和术语的处理能力更强；改进了长文档结构解析。
- 文本理解能力与纯 LLM 相当：实现无损、统一的文本视觉无缝融合，从而获得统一的理解。
模型架构更新：
<div align=center>
    <img src="./doc/qwen3vl_arc.jpg"/>
</div>

1. **Interleaved-MRoPE**: 通过稳健的位置嵌入，在时间、宽度和高度上进行全频分配，增强长时程视频推理。

2. **DeepStack**: 融合多级 ViT 特征，以捕捉精细细节并增强图像与文本的对齐。

3. **Text–Timestamp Alignment:** 超越 T-RoPE，实现基于时间戳的精确事件定位，从而增强视频时间建模能力。
## 环境依赖

|     软件     |           版本           |
| :----------: | :----------------------: |
|     DTK      |         25.04.2          |
|    python    |         3.10.12          |
| transformers |          4.57.1          |
|    torch     | 2.5.1+das.opt1.dtk25042  |
|  accelerate  |          1.11.0          |
| torchvision  | 0.20.1+das.opt1.dtk25042 |
|  flash_attn  |  2.6.1+das.opt1.dtk2504  |
|      av      |          16.0.1          |
|     vllm     |          0.11.0+das.opt1.alpha.dtk25042.20251225.gca4598a4          |
## 硬件需求
DCU型号：K100AI,节点数量：2台,卡数：16 张。


推荐使用镜像:harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name qwen3 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    harbor.sourcefind.cn:5443/dcu/admin/base/vllm:0.11.0-ubuntu22.04-dtk25.04.2-1226-das1.7-py3.10-20251226
```

更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：

```
pip install -r requirements.txt
```

## 数据集

`暂无`

## 训练
`暂无`

## 推理

### transformers
#### 单机推理
```bash
#普通图文对话
HIP_VISIBLE_DEVICES=0 python qwen3vl_infer.py
#多图像推理
HIP_VISIBLE_DEVICES=0 python qwen3vl_infer_multi_images.py
#视频推理
HIP_VISIBLE_DEVICES=0 python qwen3vl_infer_video.py
```

## vllm

#### 单机推理

```bash
## serve启动
export HF_HUB_OFFLINE=1
export TRANSFORMERS_OFFLINE=1

vllm serve Qwen/Qwen3-VL-8B-Instruct \
--trust-remote-code \
--max-model-len 32768 \
--served-model-name qwen-vl \
--dtype bfloat16 \
--tensor-parallel-size 1 \
--gpu-memory-utilization 0.9

## client访问
curl http://localhost:8000/v1/chat/completions   \
    -H "Content-Type: application/json"  \
    -d '{
        "model": "qwen-vl",
        "messages": [
            {
                "role": "user",
                "content": "牛顿提出了哪三大运动定律？请简要说明。"
            }
        ]
    }'
```

### 多机多卡推理
样例模型：[Qwen3-VL-235B-A22B-Thinking ](https://huggingface.co/Qwen/Qwen3-VL-235B-A22B-Thinking)

1. 加入环境变量
> 请注意：
> 每个节点上的环境变量都写到.sh文件中，保存后各个计算节点分别source`.sh`文件
>
> VLLM_HOST_IP：节点本地通信口ip，尽量选择IB网卡的IP，**避免出现rccl超时问题**
>
> NCCL_SOCKET_IFNAME和 GLOO_SOCKET_IFNAME：节点本地通信网口ip对应的名称
>
> 通信口和ip查询方法：ifconfig
>
> IB口状态查询：ibstat  !!!一定要active激活状态才可用，各个节点要保持统一

```bash
export ALLREDUCE_STREAM_WITH_COMPUTE=1
export VLLM_HOST_IP=x.x.x.x # 对应计算节点的IP，选择IB口SOCKET_IFNAME对应IP地址
export NCCL_SOCKET_IFNAME=ibxxxx
export GLOO_SOCKET_IFNAME=ibxxxx
export NCCL_IB_HCA=mlx5_0:1 # 环境中的IB网卡名字
unset NCCL_ALGO
export NCCL_MIN_NCHANNELS=16
export NCCL_MAX_NCHANNELS=16
export NCCL_NET_GDR_READ=1
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export VLLM_SPEC_DECODE_EAGER=1
export VLLM_MLA_DISABLE=0
export VLLM_USE_FLASH_MLA=1

# K100_AI集群建议额外设置的环境变量：
export VLLM_ENFORCE_EAGER_BS_THRESHOLD=44
export VLLM_RPC_TIMEOUT=1800000

# 海光CPU绑定核
export VLLM_NUMA_BIND=1
export VLLM_RANK0_NUMA=0
export VLLM_RANK1_NUMA=1
export VLLM_RANK2_NUMA=2
export VLLM_RANK3_NUMA=3
export VLLM_RANK4_NUMA=4
export VLLM_RANK5_NUMA=5
export VLLM_RANK6_NUMA=6
export VLLM_RANK7_NUMA=7
```

2. 启动RAY集群
> x.x.x.x 对应第一步 VLLM_HOST_IP

```bash
# head节点执行
ray start --head --node-ip-address=x.x.x.x --port=6379 --num-gpus=8 --num-cpus=32
# worker节点执行
ray start --address='x.x.x.x:6379' --num-gpus=8 --num-cpus=32
```
3. 启动vllm server

```bash
vllm serve Qwen/Qwen3-VL-235B-A22B-Thinking \
  --host x.x.x.x \
  --port 8000 \
  --distributed-executor-backend ray \
  --tensor-parallel-size 8 \
  --pipeline-parallel-size 2 \
  --trust-remote-code \
  --dtype bfloat16 \
  --max-model-len 32768 \
  --max-num-seqs 128 \
  --block-size 64 \
  --gpu-memory-utilization 0.90 \
  --allowed-local-media-path / \
  --served-model-name qwen-vl \
  --override-generation-config '{"temperature": 0.7, "top_p":0.8, "top_k":20, "repetition_penalty": 1.05}'
```

启动完成后可通过以下方式访问：
```bash
# /path/to/your/project 请改为图像文件存储的目录
curl http://x.x.x.x:8000/v1/chat/completions \
  -H "Content-Type: application/json" \
  -d '{
    "model": "qwen-vl",
    "messages": [
      {
        "role": "user",
        "content": [
          {
            "type": "image_url",
            "image_url": {
              "url": "file:///path/to/your/project/doc/test.png"
            }
          },
          {
            "type": "text",
            "text": "请详细描述这张图片的内容。"
          }
        ]
      }
    ],
    "max_tokens": 512,
    "temperature": 0.7
  }'
```


## vllm效果展示


## 效果展示

**场景1** ：普通图文对话
Input:

- image:

<div align=center>
    <img src="./doc/demo.jpeg"/>
</div>


- text: "Describe this image."

Output:

<div align=center>
    <img src="./doc/result.png"/>
</div>


**场景2** ：多图像推理
Input:

- image1:

<div align=center>
    <img src="./doc/demo.jpeg"/>
</div>


- image2:

<div align=center>
    <img src="./doc/dog.jpg"/>
</div>


- text: "Identify the similarities between these images."

Output:

<div align=center>
    <img src="./doc/result_multi_images.png"/>
</div>


**场景3** ：视频推理

- Vedio:
  ![space_woaudio](./doc/space_woaudio.mp4)

- text:: "Describe this video."

Output:

<div align=center>
    <img src="./doc/result_vedio.png"/>
</div>
### 精度

`DCU与GPU精度一致，支持推理框架：transformers、vllm。`

## 预训练权重

## Qwen3-VL 全系列模型清单

| **模型名称**                    | **权重大小** | **最低卡数需求 (K100AI)** | **下载地址 (Hugging Face)**                                  |
| ------------------------------- | ------------ | ------------------------- | ------------------------------------------------------------ |
| **Qwen3-VL-2B-Instruct**        | 2B           | 1                         | [Qwen3-VL-2B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-2B-Instruct) |
| **Qwen3-VL-4B-Instruct**        | 4B           | 1                         | [Qwen3-VL-4B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-4B-Instruct) |
| **Qwen3-VL-8B-Instruct**        | 8B           | 1                         | [Qwen3-VL-8B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-8B-Instruct) |
| **Qwen3-VL-32B-Instruct**       | 32B          | 4                         | [Qwen3-VL-32B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-32B-Instruct) |
| **Qwen3-VL-30B-A3B-Instruct**   | 30B          | 1-2                       | [Qwen3-VL-30B-A3B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-30B-A3B-Instruct) |
| **Qwen3-VL-30B-A3B-Thinking**   | 30B          | 2                         | [Qwen3-VL-30B-A3B-Thinking](https://huggingface.co/Qwen/Qwen3-VL-30B-A3B-Thinking) |
| **Qwen3-VL-235B-A22B-Instruct** | 235B         | 8                         | [Qwen3-VL-235B-A22B-Instruct](https://huggingface.co/Qwen/Qwen3-VL-235B-A22B-Instruct) |
| **Qwen3-VL-235B-A22B-Thinking** | 235B         | 16                        | [Qwen3-VL-235B-A22B-Thinking](https://huggingface.co/Qwen/Qwen3-VL-235B-A22B-Thinking) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/qwen3-vl_pytorch

## 参考资料
- https://github.com/QwenLM/Qwen3-VL
