# Qwen3-Reranker
## 论文
[Qwen3 Embedding: Advancing Text Embedding and Reranking Through Foundation Models](https://arxiv.org/abs/2506.05176)

## 模型结构
采用双编码器和交叉编码器架构。
<div align=center>
    <img src="./doc/model.png"/>
</div>

## 算法原理
Qwen3嵌入模型系列是Qwen3家族最新的专有模型，专门为文本嵌入和排序任务而设计。此系列继承了其基础模型出色的多语言能力、长文本理解和推理技能。Qwen3 嵌入系列在文本检索、代码检索、文本分类、文本聚类和双语文本挖掘等多种文本嵌入和排序任务中取得了显著进展。
<div align=center>
    <img src="./doc/methods.png"/>
</div>

## 环境配置
`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas101839-0811-das1.6-py3.10-20250812-beta
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/qwen3-reranker_pytorch
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t qwen3-reranker:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/qwen3-reranker_pytorch
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04.1
python: 3.10
vllm: 0.9.2+das.opt1.beta.dtk25041
torch: 2.5.1+das.opt1.dtk25041
deepspeed: 0.14.2+das.opt1.dtk25041
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install transformers>=4.51.0
```

## 数据集
无

## 训练
暂无

## 推理
### vllm推理方法
#### offline
```bash
## 必须添加HF_ENDPOINT环境变量
export HF_ENDPOINT=https://hf-mirror.com
export VLLM_USE_NN=0
export ALLREDUCE_STREAM_WITH_COMPUTE=1
## model_name_or_path 模型地址参数
python infer_vllm.py --model_name_or_path /path/your_model_path/
```

#### serve
```bash
export HF_ENDPOINT=https://hf-mirror.com
export VLLM_USE_NN=0
export ALLREDUCE_STREAM_WITH_COMPUTE=1

vllm serve Qwen/Qwen3-Reranker-0.6B --max-model-len 4096 --trust-remote-code --enforce-eager --enable-prefix-caching --served-model-name Qwen3-reranker --task score --disable-log-requests --hf_overrides '{"architectures":["Qwen3ForSequenceClassification"],"classifier_from_token": ["no", "yes"],"is_original_qwen3_reranker": true}'
```

测试命令：
```bash
curl http://127.0.0.1:8000/score   -H 'accept: application/json'   -H 'Content-Type: application/json'   -d '{
    "text_1": "ping",
    "text_2": "pong",
    "model": "Qwen3-reranker"
  }'
```

## result
<div align=center>
    <img src="./doc/results-dcu.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 应用场景
### 算法类别
文本理解

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [Qwen3-Reranker-0.6B](https://huggingface.co/Qwen/Qwen3-Reranker-0.6B)
- [Qwen3-Reranker-4B](https://huggingface.co/Qwen/Qwen3-Reranker-4B)
- [Qwen3-Reranker-8B](https://huggingface.co/Qwen/Qwen3-Reranker-8B)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/qwen3-reranker_pytorch

## 参考资料
- https://github.com/QwenLM/qwen3-reranker
