# Qwen3-Next

## 论文
[Qwen3-Next](https://qwen.ai/blog?id=4074cca80393150c248e508aa62983f9cb7d27cd&from=research.latest-advancements-list)

## 模型结构
Qwen3-Next-80B-A3B 是 Qwen3-Next 系列的第一个版本，具有以下关键增强功能：

- **混合注意力机制**：用 Gated DeltaNet 和 Gated Attention 的组合取代标准注意力机制，从而能够高效地对超长上下文进行建模。

- **高稀疏度混合专家（MoE）**：在 MoE 层中实现了极低的激活比率，大幅减少了每个 token 的 FLOPs，同时保持了模型容量。

- **稳定性优化**：包括**零中心化和权重衰减的层归一化**以及其他稳定增强技术，以实现稳健的预训练和后训练。

- **Multi-Token Prediction (MTP)**：提升预训练模型性能并加速推理，但是其在 Hugging Face Transformers 中通常不可用。

<div align=center>
    <img src="./doc/model.png"/>
</div>

## 算法原理
Qwen3-Next在模型架构上实现了重大突破，引入了注意力机制方面的多项创新，包括线性注意力和注意力门控机制，并进一步提高了MoE 的稀疏度。Qwen3-Next-80B-A3B 在思考模式和非思考模式下的性能均与规模更大的 Qwen3-235B-A22B-2507 相当，同时在推理速度上，特别是长上下文场景中，提升显著。

Qwen3-Next-80B-A3B 有两个版本：`Qwen3-Next-80B-A3B-Instruct` 和 `Qwen3-Next-80B-A3B-Thinking`。

> 注意：
> Qwen3-Next-80B-A3B-Instruct 仅支持指令（非思考）模式，并且在其输出中不会生成 <think></think> 块。
>
> Qwen3-Next-80B-A3B-Thinking 仅支持思考模式。 为了强制模型思考，默认的聊天模板自动包含 <think>。 因此，模型的输出可能只包含 </think> 而没有显式的 <think> 开始标签，这是正常的。

## 环境配置
### 硬件需求
DCU型号：K100_AI,节点数量：1台,卡数：4 张。

`-v 路径`、`docker_name`和`imageID`根据实际情况修改

### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas101839-0811-das1.6-py3.10-20250908-rc1
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

## 安装sglang
git clone -b v0.5.2 https://developer.sourcefind.cn/codes/OpenDAS/sglang

cd sglang
# 编译安装sgl-kernel包
cd sgl-kernel
python setup_hip.py install
# 安装sglang Python依赖
cd ..
pip install -e "python[all_hip]"

cd /your_code_path/qwen3-next_sglang
```

### Dockerfile（方法二）
```bash
cd docker
docker build --no-cache -t qwen3-next:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

## 安装sglang
git clone -b v0.5.2 https://developer.sourcefind.cn/codes/OpenDAS/sglang

cd sglang
# 编译安装sgl-kernel包
cd sgl-kernel
python setup_hip.py install
# 安装sglang Python依赖
cd ..
pip install -e "python[all_hip]"

cd /your_code_path/qwen3-next_sglang
```

### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04.1
python: 3.10.12
torch: 2.5.1+das.opt1.dtk25041
deepspeed: 0.14.2+das.opt1.dtk25041
transformers: 4.56.1
```
`Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应`

``` bash
## 安装sglang
git clone -b v0.5.2 https://developer.sourcefind.cn/codes/OpenDAS/sglang

cd sglang
# 编译安装sgl-kernel包
cd sgl-kernel
python setup_hip.py install
# 安装sglang Python依赖
cd ..
pip install -e "python[all_hip]"
```

## 数据集
无

## 训练
暂无

## 推理
### sglang推理方法
#### server
样例模型：[Qwen3-Next-80B-A3B-Instruct](https://huggingface.co/Qwen/Qwen3-Next-80B-A3B-Instruct)

启动服务：
```bash
bash start_sglang.sh
```

启动完成后可通过以下方式访问：
```bash
curl http://127.0.0.1:8001/v1/chat/completions \
    -H "Content-Type: application/json" \
    -d '{
        "model": "Qwen/Qwen3-Next-80B-A3B-Instruct",
        "messages": [
            {
                "role": "user",
                "content": "Explain Machine Learning to me in a nutshell."
            }
        ],
        "temperature": 0.7,
        "top_p": 0.8,
        "top_k": 20,
        "max_tokens": 2048,
        "stream": false
}'
```

## result
<div align=center>
    <img src="./doc/results-dcu.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：sglang。

## 应用场景
### 算法类别
对话问答

### 热点应用行业
制造,广媒,家居,教育

## 预训练权重
- [Qwen3-Next-80B-A3B-Instruct](https://huggingface.co/Qwen/Qwen3-Next-80B-A3B-Instruct)
- [Qwen3-Next-80B-A3B-Thinking](https://huggingface.co/Qwen/Qwen3-Next-80B-A3B-Thinking)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/qwen3-next_sglang

## 参考资料
- https://qwen.ai/blog?id=4074cca80393150c248e508aa62983f9cb7d27cd&from=research.latest-advancements-list
