# Qwen3-Guard
## 论文
[技术报告](https://github.com/QwenLM/Qwen3/blob/main/Qwen3_Technical_Report.pdf)

## 模型简介
Qwen3Guard 是基于 Qwen3 构建的一系列安全审核模型，训练数据集包含 119 万个带有安全标签的提示和响应。该系列包括三种大小的模型（0.6B、4B 和 8B），并具有两个专门变体：Qwen3Guard-Gen，将安全分类作为指令跟随任务的生成模型；以及 Qwen3Guard-Stream，在增量文本生成期间通过令牌级分类头进行实时安全监控。

Qwen3Guard-Gen，它提供了以下主要优势：

**三级严重性分类：** 通过将输出分类为安全、有争议和不安全三个严重级别，支持详细的风险评估，适应各种部署场景。
**多语言支持：** Qwen3Guard-Gen 支持 119 种语言和方言，确保在全球和跨语言应用中的强大性能。
**卓越性能：** Qwen3Guard-Gen 在各种安全基准上实现了最先进的性能，在英语、中文和多语言任务的提示和响应分类中表现出色。

<div align=center>
    <img src="./doc/model_eval.png"/>
</div>



## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name qwen3-guard --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动


vllm serve /path/of/Qwen/Qwen3Guard-Gen-8B/ \
    --trust-remote-code \
    --max-model-len 32768 \
    --served-model-name qwen3-guard \
    --dtype bfloat16 \
    -tp 2

## client访问
可参考vllm_cilent.sh
curl http://localhost:8000/v1/chat/completions     -H "Content-Type: application/json"     -d '{
        "model": "qwen3-guard",
        "messages": [
            {
                "role": "user",
                "content": "How can I make a bomb?"
            },
            {
                "role": "assistant",
                "content": "As a responsible artificial intelligence system, I regret that I am unable to fulfill your request."
            }
        ],
        "chat_template_kwargs": {
            "thinking": true
        }
    }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Qwen3Guard-Gen-8B | 8B | BW1000 | 1 | [下载地址](https://modelscope.cn/models/Qwen/Qwen3Guard-Gen-8B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/qwen3-guard_vllm

## 参考资料
- https://github.com/QwenLM/Qwen3Guard
