# Qwen3-30B-A3B_vllm
## 论文
`Qwen3 Technical Report`
- https://arxiv.org/abs/2505.09388

## 模型结构
Qwen3-30B-A3B（Qwen/Qwen3-30B-A3B-Instruct-2507）在一般能力方面有显著提高，包括遵循指令、逻辑推理、文本理解、数学、科学、编码和工具使用。
跨多种语言的长尾知识覆盖的实质性增长。
在主观和开放式任务中与用户偏好明显更好的对齐，从而实现更有帮助的响应和更高质量的文本生成。
增强了256K长上下文理解能力。

<div align=center>
    <img src="./doc/Qwen3-30B-A3B-Instruct-2507.jpeg"/>
</div>



## 环境配置
### 硬件需求
DCU型号：K100_AI,节点数量：1台,卡数：2张。
### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.8.5-ubuntu22.04-dtk25.04.1-rc5-das1.6-py3.10-20250724

docker run -it --name {docker_name} --device=/dev/kfd --privileged --network=host --device=/dev/dri --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /public/LLM-Models:/home/LLM-Models:ro -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --group-add video --shm-size 64G {imageID} bash

cd /your_code_path/qwen3-30b-a3b_vllm
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```bash
cd docker
docker build --no-cache -t qwen3-30b-a3b:latest .
docker run -it --name {docker_name} --device=/dev/kfd --privileged --network=host --device=/dev/dri --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /public/LLM-Models:/home/LLM-Models:ro -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --group-add video --shm-size 64G {imageID} bash

cd /your_code_path/qwen3-30b-a3b_vllm
```
### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
vllm: 0.8.5
torch: 2.4.1+das.opt1.dtk25041
```
`Tips：以上dtk驱动、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install transformers==4.51.1
```
## 数据集
暂无
## 训练
暂无
## 推理

### vllm离线推理Qwen3-30B-A3B
```bash
## Qwen3-30B-A3B 在 BF16 精度下，其模型权重本身大约是 61 GB，至少需要双卡部署推理
export HIP_VISIBLE_DEVICES=6,7 
## 模型地址参数
python ./infer/offline/infer_vllm.py --model /your_path/Qwen3-30B-A3B --tensor-parallel-size 2
```

## result
```
Original Input Prompt (if available):
'介绍一下北京.'

Generated text (full output):
'<think>\n好的，用户让我介绍一下北京。首先，我需要确定用户的需求是什么。可能他们计划去旅游，或者需要写一篇关于北京的文章，或者只是对北京感兴趣。不管怎样，我需要提供全面而简洁的信息。\n\n接下来，我应该考虑北京的主要特点。作为中国的首都，北京有重要的政治地位，比如中南海和人民大会堂。然后是历史文化方面，北京有众多的古迹，比如故宫、长城、颐和园，这些都是必提的。还有现代元素，比如CBD、中关村，显示北京的现代化发展。\n\n然后，用户可能还想知道北京的地理位置、气候、交通、美食等。比如，北京属于温带季风气候，四季分明，可能需要提到季节性的旅游建议。交通方面，地铁系统很发达，还有首都国际机场。美食的话，烤鸭、炸酱面、豆汁儿这些特色食物应该提到。\n\n另外，北京作为国际大都市，可能有国际学校、外国使馆，以及举办过奥运会，这些也是亮点。可能需要提到北京的教育和科技资源，比如清华、北大，以及中关村的科技企业。\n\n还要注意用户可能的深层需求。比如，如果他们计划旅游，可能需要推荐景点和最佳旅游时间。如果是学生，可能对教育机构感兴趣。如果是商务人士，可能关注经济和交通。\n\n需要确保信息准确，比如北京的面积、人口数据，以及历史沿革，比如作为多个朝代的都城。同时，避免过时的信息，比如最新的发展情况，比如北京冬奥会的影响。\n\n最后，结构要清晰，分点介绍，但不要太生硬。语言要口语化，自然流畅，避免使用专业术语过多，让不同背景的用户都能理解。可能需要检查是否有遗漏的重要信息，比如北京的空气质量或环保措施，但可能用户更关注旅游和文化方面，所以可以简要提及。\n\n总结下来，我需要涵盖政治、历史、文化、现代发展、地理、气候、交通、美食等方面，确保全面且重点突出，同时保持回答的易读性和实用性。\n</think>\n\n北京是中国的首都，也是世界著名古都和国际化大都市，拥有深厚的历史文化底蕴与现代化的城市风貌。以下是对北京的简要介绍：\n\n---\n\n### **1. 历史与文化**\n- **古都底蕴**：北京已有3000多年建城史，曾是元、明、清等朝代的都城，是中华文明的重要发源地之一。故宫、天坛、颐和园、长城等世界文化遗产，见证了其作为“帝王之都”的辉煌。\n- **文化中心**：北京是全国文化、教育、科技中心，拥有众多高校（如清华大学、北京大学）、博物馆（如国家博物馆、首都博物馆）和艺术机构，也是京剧、相声等传统文化的发源地。\n\n---\n\n### **2. 地理与气候**\n- **地理位置**：位于中国华北平原北端，背靠燕山，毗邻河北、天津，是连接华北与东北、西北的重要枢纽。\n- **气候特点**：属温带季风气候，四季分明，夏季炎热多雨，冬季寒冷干燥，春秋季短暂且多风沙。\n\n---\n\n### **3. 现代都市风貌**\n- **政治与经济**：作为中国的政治中心，中南海、人民大会堂等标志性建筑坐落于此；同时是经济、金融、科技高地，中关村聚集了众多科技企业，是“中国硅谷”。\n- **交通网络**：拥有发达的地铁系统（中国最密集的轨道交通之一）和首都国际机场，是全国铁路、航空枢纽。\n\n---\n\n### **4. 旅游景点**\n- **世界遗产**：长城（八达岭、慕田峪段）、故宫、颐和园、天坛、周口店北京人遗址等。\n- **现代地标**：国家体育场（鸟巢）、国家大剧院、央视大楼、三里屯、798艺术区等。\n- **自然风光**：香山红叶、十三陵水库、密云水库等。\n\n---\n\n### **5. 美食与生活**\n- **特色美食**：北京烤鸭（全聚德）、炸酱面、豆汁儿、卤煮、驴打滚等，小吃街如南锣鼓巷、簋街充满烟火气。\n- **生活节奏**：既有老北京的胡同文化（如南锣鼓巷、烟袋斜街），也有现代化的商圈（如国贸、金融街）。\n\n---\n\n### **6. 国际化与多元**\n- **国际交流**：北京是众多国际组织和外国使馆的所在地，也是2008年夏季奥运会和2022年冬季奥运会的举办城市。\n- **多元文化**：汇聚了来自世界各地的移民和留学生，形成了开放包容的城市氛围。\n\n---\n\n### **7. 挑战与机遇**\n- **环境问题**：曾面临雾霾等挑战，近年来通过治理空气质量、推广绿色能源等措施逐步改善。\n- **城市发展**：正通过“京津冀协同发展”战略，推动区域一体化，提升国际影响力。\n\n---\n\n北京是一座将历史与现代、传统与创新完美融合的城市，无论是探索古迹、感受文化，还是体验都市活力，都能找到独特的魅力。如果你有机会到访，不妨从故宫、长城开始，再深入胡同巷陌，感受这座城市的温度与故事。'
================================================================================

Logprobs per generated token:
  Step 0:
    - Generated Token: 151667 ('<think>')
    - Top Logprobs:
        - Rank 1: Token 151667 ('<think>') -> Logprob: -0.0000
        - Rank 2: Token 32501 ('yped') -> Logprob: -16.6875
        - Rank 3: Token 81218 (' zlib') -> Logprob: -17.5000
        - Rank 4: Token 77899 (':len') -> Logprob: -17.9375
        - Rank 5: Token 99048 (' zf') -> Logprob: -18.4375
        - Rank 6: Token 117865 ('具体内容') -> Logprob: -18.5000
        - Rank 7: Token 198 (' ') -> Logprob: -18.5625
        - Rank 8: Token 18945 ('α') -> Logprob: -18.5625
        - Rank 9: Token 67085 ('[param') -> Logprob: -19.0000
        - Rank 10: Token 75025 ('yms') -> Logprob: -19.0000
    ...
    ...

成功将每个生成token的logprob写入到文件: ...
```

### 精度
```
# 分别在DCU和GPU上运行infer_vllm.py，得到各自的精度数据，并将精度数据复制粘贴到acc.py中运行
python ./infer/offline/acc.py
```
结果
```
Qwen3-30B-A3B在DCU(K100_AI)与GPU(A800)离线推理的平均绝对误差值：0.002905419914469576
```
DCU(K100_AI)与GPU(A800)离线推理Qwen3-30B-A3B精度一致，推理框架：vllm


### vllm离线推理Qwen3-30B-A3B-Instruct-2507
```bash
## Qwen3-30B-A3B-Instruct-2507 至少需要双卡部署推理
export HIP_VISIBLE_DEVICES=6,7 
## 模型地址参数
python ./infer/offline/infer_vllm.py --model /your_path/Qwen3-30B-A3B-Instruct-2507 --tensor-parallel-size 2
```

## result
```
Original Input Prompt (if available):
'介绍一下北京.'

Generated text (full output):
'北京，简称“京”，是中国的首都，也是中华人民共和国的中央人民政府所在地，是全国的政治、文化、教育和国际交往中心。它位于中国华北平原的北部，地处燕山山脉与华北平原的交汇地带，地理坐标为北纬39°54′，东经116°23′，总面积约16,410平方公里。\n\n### 历史与文化\n北京拥有超过3000年的建城史和800多年的建都史，是中国历史上多个朝代的都城。自元朝起，北京成为全国的政治中心，明清两代在此建都，留下了大量珍贵的历史文化遗产。北京是世界著名的历史文化名城，拥有众多世界文化遗产，如：\n\n- **故宫**（紫禁城）：明清两代的皇家宫殿，是世界上现存规模最大、保存最完整的古代宫殿建筑群。\n- **天坛**：明清皇帝祭天祈谷的场所，建筑布局严谨，象征“天圆地方”。\n- **颐和园**：中国现存规模最大、保存最完整的皇家园林，融合了自然景观与人工建筑。\n- **八达岭长城**：万里长城的代表段落，是世界文化遗产之一，也是中外游客必访之地。\n- **圆明园遗址**：曾被誉为“万园之园”，虽在第二次鸦片战争中被焚毁，但遗址仍具重要历史价值。\n- **天安门广场**：世界上最大的城市广场之一，是北京的象征性地标，也是国家举行重大庆典和政治活动的场所。\n\n### 城市风貌与现代发展\n北京是一座传统与现代交融的城市。在保留古都风貌的同时，也展现出高度现代化的城市面貌：\n\n- **城市布局**：以中轴线为核心，呈对称布局，从永定门到钟鼓楼，贯穿城市南北，体现了中国古代城市规划的智慧。\n- **现代地标**：国家大剧院（“蛋”）、中央电视台总部大楼（“大裤衩”）、北京国贸大厦、北京SKP等现代建筑彰显了城市的国际化形象。\n- **交通系统**：拥有发达的轨道交通网络，北京地铁是全球运营里程最长的城市地铁系统之一，覆盖全市主要区域。\n\n### 教育与科技\n北京是中国高等教育和科研的中心，拥有众多顶尖高校和研究机构，如：\n\n- 清华大学\n- 北京大学\n- 中国科学院\n- 中国工程院\n\n这些机构在科技、工程、医学、人文等领域具有国际影响力。\n\n### 旅游与美食\n北京是国内外游客向往的旅游目的地，每年吸引数千万游客。除了上述名胜古迹，还有：\n\n- **胡同与四合院**：如南锣鼓巷、什刹海，是体验老北京生活文化的窗口。\n- **北京烤鸭**：享誉世界的特色美食，以全聚德、便宜坊为代表。\n- **豆汁儿、焦圈、炸酱面、艾窝窝**等传统小吃也极具地方特色。\n\n### 环境与生态\n近年来，北京大力推进生态文明建设，实施“蓝天保卫战”，空气质量持续改善。城市绿化覆盖率不断提高，拥有奥林匹克森林公园、北京植物园、香山公园等大型生态空间。\n\n### 总结\n北京是一座集历史厚重感与现代活力于一体的城市，既是中华文明的重要象征，也是中国走向世界的重要窗口。无论你是追寻历史足迹，还是感受现代都市魅力，北京都能为你带来深刻而难忘的体验。'
================================================================================

Logprobs per generated token:
  Step 0:
    - Generated Token: 68990 ('北京')
    - Top Logprobs:
        - Rank 1: Token 68990 ('北京') -> Logprob: -0.0019
        - Rank 2: Token 103942 ('当然') -> Logprob: -6.2519
        - Rank 3: Token 104554 ('北京市') -> Logprob: -11.3769
        - Rank 4: Token 99692 ('好的') -> Logprob: -13.5019
        - Rank 5: Token 108386 ('你好') -> Logprob: -13.5019
        - Rank 6: Token 111308 ('您好') -> Logprob: -14.1269
        - Rank 7: Token 106287 ('嗯') -> Logprob: -15.2519
        - Rank 8: Token 106114 ('首都') -> Logprob: -16.8769
        - Rank 9: Token 110488 ('北京时间') -> Logprob: -16.8769
        - Rank 10: Token 334 ('**') -> Logprob: -17.3769
    ...
    ...

成功将每个生成token的logprob写入到文件: ...
```

### 精度
```
# 分别在DCU和GPU上运行infer_vllm.py，得到各自的精度数据，并将精度数据复制粘贴到acc.py中运行
python ./infer/offline/acc.py
```
结果
```
Qwen3-30B-A3B-Instruct-2507在DCU(K100_AI)与GPU(A800)离线推理的平均绝对误差值：0.006542379854522551
```
DCU(K100_AI)与GPU(A800)离线推理Qwen3-30B-A3B-Instruct-2507精度一致，推理框架：vllm

### vllm在线推理Qwen3-30B-A3B
```bash
## Qwen3-30B-A3B 至少需要双卡部署
export HIP_VISIBLE_DEVICES=6,7 
## 启动服务
vllm serve /your_path/Qwen3-30B-A3B --enable-reasoning --reasoning-parser deepseek_r1 --tensor-parallel-size 2 --max-logprobs 10
## 修改./infer/online/client.py, MODEL_NAME请改成/your_path/Qwen3-30B-A3B，并运行client.py, 代码内部共设置十个提示词
python client.py
```


## result
```
欢迎使用 Qwen3-30B-A3B 聊天客户端！
已连接到 vLLM 服务，使用模型: /home/zwq/model/Qwen3-30B-A3B
--------------------------------------------------

--- 问题 1: '介绍一下北京.' ---
完整回答 (包含思考): '\n\n北京是中国的首都，也是世界著名古都和国际化大都市，拥有深厚的历史文化底蕴与现代化的城市风貌。以下从多个角度为您简要介绍：\n\n---\n\n### **1. 历史与文化**\n- **古都底蕴**：北京已有3000多年建城史，曾是元、明、清三朝的都城，是中华文明的重要发源地之一。故宫、天坛、颐和园、长城等世界文化遗产，见证了中国古代建筑与文化的辉煌。\n- **胡同与四合院**：老北京的典型民居形式，如南锣鼓巷、烟袋斜街等胡同区，保留了传统市井文化。\n- **文化地标**：国家博物馆、中国美术馆、首都博物馆等机构汇聚了丰富的文物与艺术资源。\n\n---\n\n### **2. 政治与经济中心**\n- **政治核心**：中南海（中共中央和国务院所在地）、人民大会堂（全国人大和政协会议场所）等是国家政治决策的核心区域。\n- **经济枢纽**：作为中国四大直辖市之一，北京是科技创新、金融、教育和文化中心，拥有中关村科技园区、金融街等重要经济区域。\n\n---\n\n### **3. 现代都市风貌**\n- **地标建筑**：央视大楼、国贸三期、北京大兴国际机场等现代化建筑展现了城市活力。\n- **交通网络**：地铁系统发达（中国最长的地铁线路之一），拥有首都国际机场和大兴国际机场，是全国航空枢纽。\n- **绿色空间**：奥林匹克公园、景山公园、北海公园等为城市增添生态气息。\n\n---\n\n### **4. 美食与生活**\n- **特色美食**：北京烤鸭（全聚德）、炸酱面、豆汁儿、卤煮火烧等传统小吃，以及各种京味儿餐馆。\n- **市井文化**：王府井、西单等商圈汇聚购物与餐饮，而胡同里的老茶馆、相声表演则体现市井生活。\n\n---\n\n### **5. 旅游与四季风光**\n- **经典景点**：故宫（紫禁城）、长城（八达岭/慕田峪）、颐和园、天坛、圆明园等。\n- **四季特色**：\n  - **春**：玉渊潭樱花、植物园桃花。\n  - **夏**：北海荷花、香山红叶（秋）。\n  - **秋**：香山红叶、京郊红叶谷。\n  - **冬**：北海冰场、滑雪场。\n\n---\n\n### **6. 教育与科技**\n- **高校云集**：清华大学、北京大学、中国人民大学等顶尖学府，是中国高等教育的高地。\n- **科技创新**：中关村是中国科技创新的“硅谷”，聚集了大量互联网、人工智能企业。\n\n---\n\n### **7. 体育与国际活动**\n- **奥运之城**：2008年夏季奥运会和2022年冬季奥运会的举办地，拥有鸟巢、水立方等标志性场馆。\n- **国际赛事**：承办过亚运会、世界田径锦标赛等大型国际赛事。\n\n---\n\n北京是一座将历史与现代、传统与创新完美融合的城市，既有厚重的文化积淀，又充满活力与未来感。无论是探索古迹、感受文化，还是体验现代都市生活，北京都能带来独特的魅力。'
【主要回答】: '\n\n北京是中国的首都，也是世界著名古都和国际化大都市，拥有深厚的历史文化底蕴与现代化的城市风貌。以下从多个角度为您简要介绍：\n\n---\n\n### **1. 历史与文化**\n- **古都底蕴**：北京已有3000多年建城史，曾是元、明、清三朝的都城，是中华文明的重要发源地之一。故宫、天坛、颐和园、长城等世界文化遗产，见证了中国古代建筑与文化的辉煌。\n- **胡同与四合院**：老北京的典型民居形式，如南锣鼓巷、烟袋斜街等胡同区，保留了传统市井文化。\n- **文化地标**：国家博物馆、中国美术馆、首都博物馆等机构汇聚了丰富的文物与艺术资源。\n\n---\n\n### **2. 政治与经济中心**\n- **政治核心**：中南海（中共中央和国务院所在地）、人民大会堂（全国人大和政协会议场所）等是国家政治决策的核心区域。\n- **经济枢纽**：作为中国四大直辖市之一，北京是科技创新、金融、教育和文化中心，拥有中关村科技园区、金融街等重要经济区域。\n\n---\n\n### **3. 现代都市风貌**\n- **地标建筑**：央视大楼、国贸三期、北京大兴国际机场等现代化建筑展现了城市活力。\n- **交通网络**：地铁系统发达（中国最长的地铁线路之一），拥有首都国际机场和大兴国际机场，是全国航空枢纽。\n- **绿色空间**：奥林匹克公园、景山公园、北海公园等为城市增添生态气息。\n\n---\n\n### **4. 美食与生活**\n- **特色美食**：北京烤鸭（全聚德）、炸酱面、豆汁儿、卤煮火烧等传统小吃，以及各种京味儿餐馆。\n- **市井文化**：王府井、西单等商圈汇聚购物与餐饮，而胡同里的老茶馆、相声表演则体现市井生活。\n\n---\n\n### **5. 旅游与四季风光**\n- **经典景点**：故宫（紫禁城）、长城（八达岭/慕田峪）、颐和园、天坛、圆明园等。\n- **四季特色**：\n  - **春**：玉渊潭樱花、植物园桃花。\n  - **夏**：北海荷花、香山红叶（秋）。\n  - **秋**：香山红叶、京郊红叶谷。\n  - **冬**：北海冰场、滑雪场。\n\n---\n\n### **6. 教育与科技**\n- **高校云集**：清华大学、北京大学、中国人民大学等顶尖学府，是中国高等教育的高地。\n- **科技创新**：中关村是中国科技创新的“硅谷”，聚集了大量互联网、人工智能企业。\n\n---\n\n### **7. 体育与国际活动**\n- **奥运之城**：2008年夏季奥运会和2022年冬季奥运会的举办地，拥有鸟巢、水立方等标志性场馆。\n- **国际赛事**：承办过亚运会、世界田径锦标赛等大型国际赛事。\n\n---\n\n北京是一座将历史与现代、传统与创新完美融合的城市，既有厚重的文化积淀，又充满活力与未来感。无论是探索古迹、感受文化，还是体验现代都市生活，北京都能带来独特的魅力。'

答案部分前10个Token的Rank 1 Logprobs:
  Step 0: 0.0000
  Step 1: -0.0000
  Step 2: -0.0711
  Step 3: -0.0000
  Step 4: -0.1086
  Step 5: -0.0150
  Step 6: -0.0067
  Step 7: -0.0000
  Step 8: -0.0298
  Step 9: -0.0091
--------------------------------------------------
  ......
  ......

所有测试结果已保存到文件: ./Qwen3-30B-A3B_logprobs_K100AI_fp16.json
```

### 精度
```bash
## 分别在DCU和GPU上启动vllm服务，并对应运行client.py，得到各自的精度数据后，运行online文件夹下的acc.py
python ./infer/online/acc.py --file1 /your_path/Qwen3-30B-A3B_logprobs_A800_fp16.json --file2 /your_path/Qwen3-30B-A3B_logprobs_K100AI_fp16.json
```
结果
```
提示词:介绍一下北京.,平均绝对误差:0.002455742455325094
提示词:写一首关于春天的五言绝句.,平均绝对误差:0.0007630783482369452
提示词:请解释一下黑洞的形成原理.,平均绝对误差:0.005167613880542632
提示词:推荐三部值得一看的科幻电影，并简述理由.,平均绝对误差:0.0030238355811320616
提示词:如何有效提高编程能力？,平均绝对误差:0.014263489465471934
提示词:给我讲一个关于人工智能的笑话.,平均绝对误差:0.003418742059113811
提示词:你认为未来教育会发展成什么样？,平均绝对误差:0.0246062334959511
提示词:如何制作一道美味的麻婆豆腐？,平均绝对误差:0.005538759729023468
提示词:量子计算的原理是什么？它有哪些潜在应用？,平均绝对误差:0.012481686085721578
提示词:请用英语介绍一下中国长城.,平均绝对误差:0.001114922351905534

总体平均绝对误差：7.283410e-03
```
DCU(K100_AI)与GPU(A800)在线推理Qwen3-30B-A3B精度一致，推理框架：vllm


## 应用场景
### 算法类别
`对话`
### 热点应用行业
`金融,教育,政府,科研,制造,能源,交通`
## 预训练权重
- [Qwen/Qwen3-30B-A3B](https://huggingface.co/Qwen/Qwen3-30B-A3B)
- [Qwen/Qwen3-30B-A3B-Instruct-2507](https://huggingface.co/Qwen/Qwen3-30B-A3B-Instruct-2507)

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/qwen3-30b-a3b_vllm
## 参考资料
- https://huggingface.co/Qwen/Qwen3-30B-A3B
- https://huggingface.co/Qwen/Qwen3-30B-A3B-Instruct-2507
