import torch
from vllm import LLM, SamplingParams

def main():
    # Sample prompts.
    prompts = [
        "The capital of France is",
    ]

    # Create a sampling params object.
    sampling_params = SamplingParams(temperature=0.8, top_p=0.95)

    # Create an LLM object with model path and configuration.
    llm = LLM(model="/data/model/Qwen2-72B-Instruct/",
              tensor_parallel_size=4,
              trust_remote_code=True,
              dtype="float16",
              enforce_eager=True)

    # Generate texts from the prompts.
    outputs = llm.generate(prompts, sampling_params)

    # Print the outputs.
    for output in outputs:
        prompt = output.prompt
        generated_text = output.outputs[0].text
        print(f"Prompt: {prompt!r}, Generated text: {generated_text!r}")

if __name__ == '__main__':
    main()


