# Qwen Efficient Tuning

## 模型介绍

```
通义千问-7B（Qwen-7B） 是阿里云研发的通义千问大模型系列的70亿参数规模的模型。Qwen-7B是基于Transformer的大语言模型, 在超大规模的预训练数据上进行训练得到。预训练数据类型多样，覆盖广泛，包括大量网络文本、专业书籍、代码等。
```

## 模型结构

```
模型架构：Qwen-7B的构建采用了类似LLaMA的架构。与标准transformer的主要差异有：1）使用非连接嵌入、2）使用旋转位置嵌入、3）在注意力中除了QKV外不使用偏置、4）使用RMSNorm代替LayerNorm、5）使用SwiGLU代替ReLU、以及6）采用快速注意力来加速训练。该模型共有32层，嵌入维度为4096，注意力头数为32。
```

## 数据集

```
使用alpaca_gpt4_zh数据集，已经包含在data目录中，具体文件为alpaca_gpt4_data_zh.json
```

## 模型下载

[Qwen模型下载](https://huggingface.co/Qwen/Qwen-7B-Chat/tree/main)

## Qwen训练

### 环境配置

推荐使用docker方式运行，提供[光源](https://www.sourcefind.cn/#/main-page)拉取的docker镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py39-latest
```

进入docker

```
pip install -r requirements.txt  -i https://mirrors.aliyun.com/pypi/simple/  --trusted-host mirrors.aliyun.com
```

其中apex、torch、deepspeed需要到[开发者社区](https://cancon.hpccube.com:65024/4/main/)下载对应版本

### 训练（单节点）

```
bash run-node.sh
```

### 训练（集群多节点）

```
#需要修改对应的节点名、加载对应虚拟环境以及模型路径等
#集群运行
sbatch run-dtk23.04.sh
```



## 模型训练Loss

乌镇集群两节点zero3训练

|         train         |  loss  |
| :-------------------: | :----: |
| 1.44epoch（8780step） | 1.3917 |



## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/qwen-torch

## 参考

https://github.com/hiyouga/LLaMA-Efficient-Tuning/tree/main
