# Qwen-Image_hf
## 论文
`Qwen-Image Technical Report`
- https://qianwen-res.oss-cn-beijing.aliyuncs.com/Qwen-Image/Qwen_Image.pdf
## 模型结构
Qwen-Image，一个20B的MMDiT模型。这是通义千问系列中首个图像生成基础模型，其在复杂文本渲染和精确图像编辑方面取得了显著进展。其主要特性包括：
- 卓越的文本渲染能力: Qwen-Image 在复杂文本渲染方面表现出色，支持多行布局、段落级文本生成以及细粒度细节呈现。无论是英语还是中文，均能实现高保真输出。
- 一致性的图像编辑能力: 通过增强的多任务训练范式，Qwen-Image 在编辑过程中能出色地保持编辑的一致性。
- 强大的跨基准性能表现: 在多个公开基准测试中的评估表明，Qwen-Image 在各类生成与编辑任务中均获得SOTA，是一个强大的图像生成基础模型。

<div align=center>
    <img src="./doc/MMDIT.png"/>
</div>

## 算法原理
Qwen-Image的核心是扩散模型，并创新地使用了一个强大的多模态大语言模型(Qwen2.5-VL)来深度理解复杂的图文指令，从而在生成高质量图像的同时，实现了业界领先的、尤其是在中英文上的精准文字渲染能力。

<div align=center>
    <img src="./doc/qwen-image.png"/>
</div>

## 环境配置
### 硬件需求
DCU型号：K100_AI,节点数量：1台,卡数：2张。
### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250612-fixpy-rocblas0611-rc2

docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/qwen-image_hf

pip install -r requirements.txt
# 需要安装torch2.5.1或以上版本
wget https://download.sourcefind.cn:65024/directlink/4/pytorch/DAS1.6/torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```bash
cd docker
docker build --no-cache -t qwen-image:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/qwen-image_hf

pip install -r requirements.txt
# 需要安装torch2.5.1或以上版本
wget https://download.sourcefind.cn:65024/directlink/4/pytorch/DAS1.6/torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
```
### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
torch: 2.5.1+das.opt2.dtk25041
```
`Tips：以上dtk驱动、pytorch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt
```
## 数据集
暂无
## 训练
暂无
## 推理
### diffusers推理方法
```bash
## 设置双卡推理
export HIP_VISIBLE_DEVICES=6,7
## 代码内部请修改model_name路径
python ./infer/infer_hf.py 
```

## result
```bash
正在加载模型... 这可能需要一些时间。
......
模型加载成功！
所有图片将保存在 'generated_images_DCU' 文件夹中。

正在处理第 1/11 个prompt...
Prompt: 'A cute capybara wearing a top hat, sitting in a library....'
100%|████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████████| 50/50 [01:20<00:00,  1.61s/it]
图片已成功保存为: 'generated_images_DCU/prompt_0.png'
......

所有prompt处理完毕！
```

### 精度
```bash
# 运行acc.py之前，请分别在DCU和GPU上运行infer_hf.py，并将代码中folder_gpu变量和folder_dcu变量替换成生成的文件夹路径
开始对比文件夹 '/home/zwq/project/shangchaun/external/qwen-image_hf/infer/generated_images_GPU' (基准) 和 '/home/zwq/project/shangchaun/external/qwen-image_hf/infer/generated_images_DCU' (测试)...
  - 对比 prompt_0.png: MAE=1.0268, PSNR=40.89dB, SSIM=0.9944
  - 对比 prompt_1.png: MAE=2.7091, PSNR=28.35dB, SSIM=0.9760
  - 对比 prompt_10.png: MAE=1.5839, PSNR=36.26dB, SSIM=0.9844
  - 对比 prompt_2.png: MAE=2.8871, PSNR=29.00dB, SSIM=0.9636
  - 对比 prompt_3.png: MAE=2.2327, PSNR=30.49dB, SSIM=0.9750
  - 对比 prompt_4.png: MAE=2.3045, PSNR=31.78dB, SSIM=0.9778
  - 对比 prompt_5.png: MAE=2.0608, PSNR=30.85dB, SSIM=0.9819
  - 对比 prompt_6.png: MAE=2.9847, PSNR=27.91dB, SSIM=0.9639
  - 对比 prompt_7.png: MAE=0.9722, PSNR=37.80dB, SSIM=0.9933
  - 对比 prompt_8.png: MAE=1.8605, PSNR=33.35dB, SSIM=0.9839
  - 对比 prompt_9.png: MAE=2.8696, PSNR=29.13dB, SSIM=0.9718

==================================================
--- 批量对比平均结果 ---
成功对比图片对数: 11
平均绝对误差 (MAE): 2.1356
平均峰值信噪比 (PSNR): 32.35 dB
平均结构相似性 (SSIM): 0.9787
==================================================

详细报告已保存至: comparison_report.csv
```

DCU(K100AI)与GPU(A800)在BF16精度下推理Qwen-Image模型，结果精度一致，推理框架：diffusers。
## 应用场景
### 算法类别
`图像生成`
### 热点应用行业
`制造,金融,教育`
## 预训练权重
- [Qwen/Qwen-Image](https://huggingface.co/Qwen/Qwen-Image)
## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/qwen-image_hf
## 参考资料
- https://github.com/QwenLM/Qwen-Image/tree/main

