# Qwen-Image-Edit_hf
## 论文
`Qwen-Image Technical Report`
- https://qianwen-res.oss-cn-beijing.aliyuncs.com/Qwen-Image/Qwen_Image.pdf
## 模型结构
Qwen-Image-Edit 是 Qwen-Image 的图像编辑版本。它基于强大的 20B Qwen-Image 模型构建而成，成功地将 Qwen-Image 独特的文字呈现能力扩展到了图像编辑任务中，实现了精准的文字编辑功能。此外，Qwen-Image-Edit 同时将输入的图像传递给 Qwen2.5-VL（用于视觉语义控制）和 VAE 编码器（用于视觉外观控制），从而在语义和外观编辑方面都具备了相应的能力。

<div align=center>
    <img src="./doc/MMDIT.png"/>
</div>

## 算法原理
Qwen-Image-Edit的核心是扩散模型，并创新地使用了一个强大的多模态大语言模型(Qwen2.5-VL)来深度理解复杂的图文指令，从而在生成高质量图像的同时，实现了业界领先的、尤其是在中英文上的精准文字渲染能力。

<div align=center>
    <img src="./doc/qwen-image.png"/>
</div>

## 环境配置
### 硬件需求
DCU型号：K100_AI,节点数量：1台,卡数：2张。
### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:vllm0.8.5-ubuntu22.04-dtk25.04-rc7-das1.5-py3.10-20250612-fixpy-rocblas0611-rc2

docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/qwen-image-edit_hf

pip install -r requirements.txt
# 需要安装torch2.5.1或以上版本
wget https://download.sourcefind.cn:65024/directlink/4/pytorch/DAS1.6/torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
```
### Dockerfile（方法二）
此处提供dockerfile的使用方法
```bash
cd docker
docker build --no-cache -t qwen-image-edit:latest .
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/qwen-image-edit_hf

pip install -r requirements.txt
# 需要安装torch2.5.1或以上版本
wget https://download.sourcefind.cn:65024/directlink/4/pytorch/DAS1.6/torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
pip install torch-2.5.1+das.opt1.dtk25041-cp310-cp310-manylinux_2_28_x86_64.whl
```
### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
torch: 2.5.1+das.opt2.dtk25041
```
`Tips：以上dtk驱动、pytorch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt
```
## 数据集
暂无
## 训练
暂无
## 推理
### diffusers推理方法
```bash
## 设置双卡推理
export HIP_VISIBLE_DEVICES=6,7
## 代码内部请修改model_name路径
python ./infer/infer_hf.py 
```

## result
```bash
Processing task 1:
......
...... 
......
All inference tasks completed.
```

### 精度
```bash
# 运行acc.py之前，请分别在DCU和GPU上运行infer_hf.py，并将代码中folder_gpu变量和folder_dcu变量替换成生成的文件夹路径
开始对比文件夹 './output_images_A800' (基准) 和 './output_images_K100AI' (测试)...
  - 对比 Add_a_small_wooden_output_5.png: MAE=2.0897, PSNR=32.24dB, SSIM=0.9842
  - 对比 Change_the_word_output_2.png: MAE=0.4869, PSNR=39.33dB, SSIM=0.9954
  - 对比 Replace_the_background_output_4.png: MAE=1.7056, PSNR=31.50dB, SSIM=0.9824
  - 对比 Replace_the_woman_output_6.png: MAE=0.3702, PSNR=50.32dB, SSIM=0.9975
  - 对比 Take_a_Breather_output_1.png: MAE=0.4357, PSNR=41.63dB, SSIM=0.9963

==================================================
--- 批量对比平均结果 ---
成功对比图片对数: 5
平均绝对误差 (MAE): 1.0176
平均峰值信噪比 (PSNR): 39.00 dB
平均结构相似性 (SSIM): 0.9912
==================================================
```

DCU(K100AI)与GPU(A800)在BF16精度下推理Qwen-Image-Edit模型，结果精度一致，推理框架：diffusers。
## 应用场景
### 算法类别
`图像生成`
### 热点应用行业
`制造,金融,教育`
## 预训练权重
- [Qwen/Qwen-Image-Edit](https://hf-mirror.com/Qwen/Qwen-Image-Edit)
## 源码仓库及问题反馈
- http://developer.sourcefind.cn/codes/modelzoo/qwen-image-edit_hf.git
## 参考资料
- https://qwenlm.github.io/blog/qwen-image-edit/

