# Qwen-7B_CPP

## 模型介绍
通义千问-7B（Qwen-7B） 是阿里云研发的通义千问大模型系列的70亿参数规模的模型。Qwen-7B是基于Transformer的大语言模型, 在超大规模的预训练数据上进行训练得到。预训练数据类型多样，覆盖广泛，包括大量网络文本、专业书籍、代码等。同时，在Qwen-7B的基础上，使用对齐机制打造了基于大语言模型的AI助手Qwen-7B-Chat。

本项目主要针对Qwen-7B-Chat在DCU平台的推理性能优化，达到DCU平台较快的对话效果。

## 模型结构

Qwen-7B的构建采用了类似LLaMA的架构。与标准transformer的主要差异有：1）使用非连接嵌入、2）使用旋转位置嵌入、3）在注意力中除了QKV外不使用偏置、4）使用RMSNorm代替LayerNorm、5）使用SwiGLU代替ReLU、以及6）采用快速注意力来加速训练。该模型共有32层，嵌入维度为4096，注意力头数为32。

## 模型下载

[原版Qwen模型下载](https://huggingface.co/Qwen/Qwen-7B-Chat/tree/main)

## 模型推理

### 环境准备

在光源可拉取推理的docker镜像，拉取方式如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py38-latest
```

### 容器启动

模型推理容器启动命令参考如下，用户根据需要修改：

```
# <container_name> 自定义容器名
# <project_path> 当前工程所在路径
docker run -it --name=<container_name> -v <project_path>:/work --device=/dev/kfd --device=/dev/dri --security-opt seccomp=unconfined --cap-add=SYS_PTRACE --shm-size=16G --group-add 39 image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-centos7.6-dtk-23.04-py38-latest /bin/bash
```

### 加载环境

进入容器后执行如下命令，加载运行环境变量

```
source /opt/dtk-23.04/cuda/env.sh
```

### 安装方法

```
#进入本工程目录
cd package
python setup install
```

### 模型转换

```
# 为了精简镜像，光源镜像中未包含模型推理时不需要的原版qwen模型运行所需要的依赖，
# 如果有现成的原版qwen-7b的运行环境中，可以将模型转换脚本qwen2flm.py移动到原版qwen-7b的运行环境中，
# 也可以通过执行pip install -r requirements.txt安装模型转换所需依赖；
# 如果使用已经下载完成的模型或者自己finetune的模型需要修改qwen2flm.py文件中创建tokenizer, model时的模型存放路径
# 执行：
python3 qwen2flm.py qwen-7b-fp16.bin float16 # 导出fp16模型，参数为导出的模型路径
python3 qwen2flm.py qwen-7b-int8.bin int8 #    导出int8模型，参数为导出的模型路径
```


### 模型推理

```
# 命令行聊天程序，使用了模型创建以及流式对话效果
python cli_demo.py -p qwen-7b-int8.bin

# 简易webui，需要先安装streamlit-chat
streamlit run web_demo.py qwen-7b-int8.bin 

# 可以使用benchmark程序进行性能测试，根据./benchmark -h描述进行配置和测试
# 测试示例如下：
./benchmark -p qwen-7b-int8.bin -f prompts/beijing.txt -b 1
./benchmark -p qwen-7b-int8.bin -f prompts/beijing.txt -b 1
./benchmark -p qwen-7b-int8.bin -f prompts/hello.txt -b 512 -l 18
# 如果benchmark没有可执行权限，需要手动添加后执行性能测试
chmod +x benchmark
```

## 运行效果展示

![qwen推理](qwen推理.gif)

## 应用场景

### 算法类别

```
NLP,对话问答
```

### 热点应用行业

```
金融,教育,政府,交通等
```

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/qwen-7b_cpp

## 参考

https://github.com/QwenLM/Qwen-7B
