<!--
 * @Author: zhuww
 * @email: zhuww@sugon.com
 * @Date: 2023-04-15 14:34:07
 * @LastEditTime: 2023-04-01 14:08:01
-->
# ProteinMPNN
## 模型介绍
ProteinMPNN是一种使用MPNN进行蛋白质预测的模型,该模型输入蛋白质序列和结构信息,输出蛋白质的三维结构
## 模型结构
模型包括3个Encoder,3个Decoder和128个隐藏层的MPNN,使用蛋白质骨干网络特征(Cα-Cα原子之间的距离，相对Cα-Cα-Cα框架的方向和旋转，以及主干二面角)作为输入，以自回归方式从N到C端预测蛋白质序列。
## 数据集
模型数据集[PDB biunits 2021/08/02](https://files.ipd.uw.edu/pub/training_sets/pdb_2021aug02.tar.gz)，数据集大小为16.5GB。
用于测试此数据集的小样本[PDB biunits sample 2021/08/02](https://files.ipd.uw.edu/pub/training_sets/pdb_2021aug02_sample.tar.gz)，数据集大小为47MB。

## 推理
### 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
* 推理镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:proteinmpnn-dtk-22.10-patch4-py37

激活镜像环境：
`source /opt/dtk-22.10/env.sh`

测试目录：
`/opt/ProteinMPNN-main`

### 推理
我们分别提供了基于Pytorch的单体和多体的推理脚本，版本依赖：
* Pytorch(DCU版本) >= 1.10.0a0
* Torchvision(DCU版本) >= 1.10.0a0
* Torchaudio(DCU版本) >= 1.10.0
#### 单体

    cd examples
    ./submit_example_1.sh

#### 多体

    cd examples
    ./submit_example_2.sh

## 准确率数据
测试数据：`/opt/ProteinMPNN-main/inputs`，使用的加速卡:1张 DCU Z100L-32G

准确率数据：
| batch size | 数据类型 | 序列类型 | 序列标签 | 序列长度 | Sequence recovery(%) | 
| :------: | :------: | :------: |:------: |:------: |:------: |
| 1 | fp32 | 单体 | 5L33 | 106 | 39.6 | 
| 1 | fp32 | 单体 | 6MRR | 68  | 39.7 |
| 1 | fp32 | 多体 | 3HTN | 429 | 55.7 |
| 1 | fp32 | 多体 | 4YOW | 693 | 57.7 |

## 源码仓库及问题反馈
* https://developer.hpccube.com/codes/modelzoo/ProteinMPNN_Pytorch
## 参考
* [https://github.com/dauparas/ProteinMPNN](https://github.com/dauparas/ProteinMPNN)

