<!--
 * @Author: zhuww
 * @email: zhuww@sugon.com
 * @Date: 2023-04-15 14:34:07
 * @LastEditTime: 2023-10-09 17:11:01
-->
# PROTEINMPNN
## 论文
- [https://www.biorxiv.org/content/10.1101/2022.06.03.494563v1](https://www.biorxiv.org/content/10.1101/2022.06.03.494563v1)

## 模型结构
模型包括3个Encoder,3个Decoder和128个隐藏层的MPNN,使用蛋白质骨干网络特征(Cα-Cα原子之间的距离，相对Cα-Cα-Cα框架的方向和旋转，以及主干二面角)作为输入，以自回归方式从N到C端预测蛋白质序列。

![img](./docs/proteinmpnn.png)

## 算法原理
ProteinMPNN是一种使用MPNN进行蛋白质预测的模型,该模型输入蛋白质序列和结构信息,输出蛋白质的三维结构

![img](./docs/proteinmpnn_1.png)

## 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:proteinmpnn-dtk-24.04.2-patch4-py310
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name proteinmpnn --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal:ro -v <Host Path>:<Container Path> <Image ID> /bin/bash
```

镜像版本依赖：
* DTK驱动：dtk24.04.2
* Pytorch: 2.3.0
* Torchvision >= 0.18.1
* Torchaudio >= 2.1.2
* python: python3.10

激活镜像环境：
`source /opt/dtk-24.04.2/env.sh`

测试目录：
`/opt/ProteinMPNN-main`

## 数据集
模型数据集[PDB biunits 2021/08/02](https://files.ipd.uw.edu/pub/training_sets/pdb_2021aug02.tar.gz)，数据集大小为16.5GB。
用于测试此数据集的小样本[PDB biunits sample 2021/08/02](https://files.ipd.uw.edu/pub/training_sets/pdb_2021aug02_sample.tar.gz)，数据集大小为47MB。  
SCNet快速下载链接[http://113.200.138.88:18080/aidatasets/project-dependency/pdb_2021/-/raw/master/pdb_2021aug02.tar.gz
](http://113.200.138.88:18080/aidatasets/project-dependency/pdb_2021/-/raw/master/pdb_2021aug02.tar.gz
)
```
pdb_2021aug02_sample/                             
    pdb/
        l3/  
            1l30_A.pt
            1l30.pt
            1l3n_B.pt
            ...
    valid_clusters.txt
    test_clusters.txt
    README
    list.csv
```

## 训练
### 单机单卡

    pip install python-dateutil
    cd /opt/ProteinMPNN-main/training

    python ./training.py \
           --path_for_outputs "模型保存路径" \
           --path_for_training_data "数据集下载并解压路径/pdb_2021aug02" \
           --num_epochs 指定训练多少个epoch \
           --save_model_every_n_epochs 每几个epochs保存模型权重

    #使用示例
    #python ./training.py \
    #       --path_for_outputs "./exp_020" \
    #       --path_for_training_data "/opt/ProteinMPNN-main/pdb_2021aug02_sample" \
    #       --num_epochs 100 \
    #       --save_model_every_n_epochs 2

## 推理
分别提供了基于Pytorch的单体和多体的推理脚本。
### 单体

    cd  /opt/ProteinMPNN-main/examples
    ./submit_example_1.sh

### 多体

    cd  /opt/ProteinMPNN-main/examples
    ./submit_example_2.sh

## result
```

training/
    exp_020/
        model_weights/
            epoch_last.pt
    log.txt
outputs/
    example_1_outputs/
        seqs/
            5L33.fa
            6MRR.fa
        parsed_pdbs.jsonl
    example_2_outputs/
        seqs/
            3HTN.fa
            4YOW.fa
        assigned_pdbs.jsonl
        parsed_pdbs.jsonl

```

## 精度
测试数据：`/opt/ProteinMPNN-main/inputs`，使用的加速卡:1张 DCU K100_AI-64G

准确率数据：
| batch size | 数据类型 | 序列类型 | 序列标签 | 序列长度 | Sequence recovery(%) |
| :------: | :------: | :------: |:------: |:------: |:------: |
| 1 | fp32 | 单体 | 5L33 | 106 | 46.23 |
| 1 | fp32 | 单体 | 6MRR | 68  | 57.35 |
| 1 | fp32 | 多体 | 3HTN | 429 | 61.35 |
| 1 | fp32 | 多体 | 4YOW | 693 | 64.32 |

## 应用场景

### 算法类别
蛋白质结构预测

### 热点应用行业
医疗,科研,教育


## 源码仓库及问题反馈
* [https://developer.hpccube.com/codes/modelzoo/proteinmpnn_pytorch](https://developer.hpccube.com/codes/modelzoo/proteinmpnn_pytorch)
## 参考资料
* [https://github.com/dauparas/ProteinMPNN](https://github.com/dauparas/ProteinMPNN)

