<!--
 * @Author: zhuww
 * @email: zhuww@sugon.com
 * @Date: 2023-04-15 14:34:07
 * @LastEditTime: 2023-08-24 10:06:01
-->
# PROTEINMPNN
## 论文
- [https://www.biorxiv.org/content/10.1101/2022.06.03.494563v1](https://www.biorxiv.org/content/10.1101/2022.06.03.494563v1)

## 模型结构
模型包括3个Encoder,3个Decoder和128个隐藏层的MPNN,使用蛋白质骨干网络特征(Cα-Cα原子之间的距离，相对Cα-Cα-Cα框架的方向和旋转，以及主干二面角)作为输入，以自回归方式从N到C端预测蛋白质序列。

![img](./docs/proteinmpnn.png)

## 算法原理
ProteinMPNN是一种使用MPNN进行蛋白质预测的模型,该模型输入蛋白质序列和结构信息,输出蛋白质的三维结构

![img](./docs/proteinmpnn_1.png)

## 环境配置
提供[光源](https://www.sourcefind.cn/#/service-details)拉取推理的docker镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:proteinmpnn-dtk-22.10-patch4-py37
# <Image ID>用上面拉取docker镜像的ID替换
# <Host Path>主机端路径
# <Container Path>容器映射路径
docker run -it --name proteinmpnn --shm-size=32G  --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v <Host Path>:<Container Path> <Image ID> /bin/bash
```

镜像版本依赖：
* DTK驱动：dtk22.10
* Pytorch: 1.10
* Torchvision >= 1.10.0
* Torchaudio >= 1.10.0
* python: python3.7

激活镜像环境：
`source /opt/dtk-22.10/env.sh`

测试目录：
`/opt/ProteinMPNN-main`

## 数据集
模型数据集[PDB biunits 2021/08/02](https://files.ipd.uw.edu/pub/training_sets/pdb_2021aug02.tar.gz)，数据集大小为16.5GB。
用于测试此数据集的小样本[PDB biunits sample 2021/08/02](https://files.ipd.uw.edu/pub/training_sets/pdb_2021aug02_sample.tar.gz)，数据集大小为47MB。

## 训练
### 单机单卡

    cd /opt/ProteinMPNN-main/training
    python ./training.py \
           --path_for_outputs "模型保存路径" \
           --path_for_training_data "数据集下载并解压路径/pdb_2021aug02" \
           --num_examples_per_epoch 1个epoch加载的训练example数量 \
           --save_model_every_n_epochs 每几个epochs保存模型权重

## 推理
分别提供了基于Pytorch的单体和多体的推理脚本。
### 单体

    cd examples
    ./submit_example_1.sh

### 多体

    cd examples
    ./submit_example_2.sh

## result
```

training/
    exp_020/
        model_weights/
            epoch_last.pt
    log.txt
outputs/
    example_1_outputs/
        seqs/
            5L33.fa
            6MRR.fa
        parsed_pdbs.jsonl
    example_2_outputs/
        seqs/
            3HTN.fa
            4YOW.fa
        assigned_pdbs.jsonl
        parsed_pdbs.jsonl

```

## 精度
测试数据：`/opt/ProteinMPNN-main/inputs`，使用的加速卡:1张 DCU Z100L-32G

准确率数据：
| batch size | 数据类型 | 序列类型 | 序列标签 | 序列长度 | Sequence recovery(%) |
| :------: | :------: | :------: |:------: |:------: |:------: |
| 1 | fp32 | 单体 | 5L33 | 106 | 39.6 |
| 1 | fp32 | 单体 | 6MRR | 68  | 39.7 |
| 1 | fp32 | 多体 | 3HTN | 429 | 55.7 |
| 1 | fp32 | 多体 | 4YOW | 693 | 57.7 |

## 应用场景

### 算法类别
NLP

### 热点应用行业
医疗,科研,教育


## 源码仓库及问题反馈
* [https://developer.hpccube.com/codes/modelzoo/proteinmpnn_pytorch](https://developer.hpccube.com/codes/modelzoo/proteinmpnn_pytorch)
## 参考资料
* [https://github.com/dauparas/ProteinMPNN](https://github.com/dauparas/ProteinMPNN)

