#pragma once
#include <ft2build.h>
#include FT_FREETYPE_H
#include <opencv2/opencv.hpp>

class PutText {
private:
    FT_Library ft;
    FT_Face face;
public:
    PutText(const char* font_path);
    ~PutText();

    /**
     * @brief 向图片写文字（支持中文）
     * @param img    待叠加字符的图片
     * @param text     待叠加的字符
     * @param x        垂直方向缩放比例
     * @param y        水平方向缩放比例
     * @param fontSize 原始图像
     * @param color    字体颜色，默认绿色
     * 
     * @return  无返回值
     */
    void putText(cv::Mat& img, const std::string& text, int x, int y, int fontSize=2, cv::Scalar color=cv::Scalar(0, 255, 0));
};
