# Paddle Ocr v5

## 论文
A Practical Ultra Lightweight OCR System

- https://arxiv.org/pdf/2009.09941

## 模型结构
详细结构通过netron（ https://netron.app/ ） 查看
- DBNet
 ![alt text](Doc/Images/DBNet.png)

- CRNN
![alt text](Doc/Images/CRNN.png)
## 算法原理

使用DBNet对字符区域进行分隔，并对分割后的二值图用Vatti Clipping算法对字符区域多边形简化处理，找到精确的字符区域，然后将精确的字符图片送入到CRNN网络，CRNN负责提取图片的特征，学习字符序列的上下文关系，输出是一个概率分布序列（每个时间步对应一个字符类别的概率分布），CTC 层是 CRNN 的核心组成部分之一，它解决了如何将 RNN 输出的不定长概率序列对齐到不定长的目标标签序列（即真实文本）的问题，将输出的概率序列解码为最终的文本字符串。
![alt text](Doc/Images/pipeline.png)

## 环境配置

### Docker（方法一）

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:5.0.0-ubuntu22.04-dtk25.04.1-py3.10
```

创建并启动容器：

```plaintext
docker run --shm-size 16g --network=host --name=ppocr_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/ppocr_migraphx:/home/ppocr_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```plaintext
cd ./docker
docker build --no-cache -t ppocrv5_migraphx:1.0 .

docker run --shm-size 16g --network=host --name=ppocr_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/ppocr_migraphx:/home/ppocr_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据需求上传所需图像，测试图片位于Resource/Image下

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python API调用示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

```python
# 进入ppocrv5 migraphx工程根目录
cd <ppocrv5_migraphx> 
# 进入示例程序目录
cd Python/
# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

```
如果测试环境是离线环境，可手动安装需要的依赖（shapely，pyclipper），依赖文件存放在3rdParty/rbuild_depend目录下
运行示例程序：
```
python inference.py
```
结果图片保存在当前目录下：res.jpg

### C++版本推理

下面介绍如何运行C++代码示例，C++ API调用示例的详细说明见Doc目录下的Tutorial_Cpp.md。

#### 安装Opencv依赖

```python
cd <path_to_ppocrv5_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```

#### 安装OpenCV并构建工程

```
rbuild build -d depend
```

如果构建不成功可手动编译OpenCV，步骤如下：
- 进入到3rdParty下解压opencv，tar -xvzf opencv-3.4.11_mini.tar.gz
- 进入到opencv-3.4.11_mini目录下创建build目录，cd build
- 执行以下命令：
```
cmake -D CMAKE_BUILD_TYPE=RELEASE -D CMAKE_INSTALL_PREFIX=./opencv_dep -D INSTALL_C_EXAMPLES=ON -D INSTALL_PYTHON_EXAMPLES=ON  -D OPENCV_GENERATE_PKGCONFIG=ON -D BUILD_EXAMPLES=ON -D OPENCV_EXTRA_MODULES_PATH=../modules/ ..
```
- 执行make -j8 && make install,编译的头文件和库目录存放在opencv_dep,将opencv_dep目录拷贝到3rdParty,并命名为opencv

#### 运行示例

```python
# 进入ppocrv5 migraphx工程根目录
cd <path_to_ppocrv5_migraphx> 

# 进入build目录
cd build/

#编译
cmake .. && make 
#运行
./ppOcrV5cd 
```
结果图片保存在当前目录下：res.jpg

## result

### Python版本

输出结果中展示了识别到的字符，每个字符后面跟着一个置信度，置信度值越大，识别结果越准确。

```
'0', 0.991
纯臻营养护发素, 1.000
'0'.'9''9''3''6''0''4', 0.999
'1', 0.998
产品信息/参数, 0.934
'0'.'9''9''2''7''2''8', 0.999
'2', 0.999
（'4''5'元／每公斤，'1''0''0'公斤起订）, 0.970
'0'.'9''7''4''1''7', 0.999
'3', 0.999
每瓶'2''2'元，'1''0''0''0'瓶起订）, 0.998
'0'.'9''9''3''9''7''6', 0.999
'4', 0.998
【品牌】：代加工方式/'0'EMODM, 0.959
'0'.'9''8''5''1''3''3', 0.998
'5', 0.998
【品名】：纯臻营养护发素, 0.997
'0'.'9''9''5''0''0''7', 0.999
'6', 0.995
【产品编号】：YM'-'X'-''3''0''1''1''0'.'9''6''8''9''9', 0.973
'7', 0.999
【净含量】：'2''2''0'ml, 0.994
'0'.'9''9''6''5''7''7', 0.999
'8', 0.998
【适用人群】：适合所有肤质, 0.997
'0'.'9''9''5''8''4''2', 0.999
'9', 0.997
【主要成分】：鲸蜡硬脂醇、燕麦B'-'葡聚, 0.976
'0'.'9''6''1''9''2''8', 0.999
'1''0', 1.000
糖、椰油酰胺丙基甜菜碱、泛醒, 0.996
'0'.'9''2''5''8''9''8', 0.999
'1''1', 0.999
（成品包材）, 0.998
'0'.'9''7''2''5''7''3', 0.999
'1''2', 1.000
【主要功能】：可紧致头发磷层，从而达到, 0.992
'0'.'9''9''4''4''4''8', 0.999
'1''3', 0.999
即时持久改善头发光泽的效果，给干燥的头, 0.989
'0'.'9''9''0''1''9''8', 0.999
'1''4', 0.999
发足够的滋养, 0.999
'0'.'9''9''7''6''6''8', 0.999
花费了'0'.'4''5''7''3''3''5'秒, 0.993
[Time info] elapsed:578.6152 ms
```

### C++版本
```
ocr res :花费了'0'.'4''5''7''3''3''5'秒  0.984009
ocr res :'0'.'9''9''7'  0.773633
ocr res :发足够的滋养  0.96818
ocr res :'1'  0.697754
ocr res :'0''0'.'9''9''0''1''9'  0.656647
ocr res :即时持久改善头发光泽的效果，给干燥的头  0.996608
ocr res :  0
ocr res :【主要功能】：可紧致头发磷层，从而达到  0.993421
ocr res :'0'.'9''9''4''4'  0.677327
ocr res :  0
ocr res :'0'.'9''7''2'  0.637158
ocr res :（成品包材）  0.901937
ocr res :'1'  0.32251
ocr res :糖、椰油酰胺丙基甜菜碱、泛醒  0.993478
ocr res :'0'.'9''2''5'  0.586279
ocr res :'1''0'  0.547241
ocr res :【主要成分】：鲸蜡硬脂醇、燕麦B'-'葡聚  0.975303
ocr res :'0'.'9''1''9'  0.568408
ocr res :  0
ocr res :'0'.'9''9''5''2'  0.613647
ocr res :【适用人群】：适合所有肤质  0.996882
ocr res :'8'  0.378906
ocr res :'0'.'9''9'  0.595581
ocr res :【净含量】：'2''2''0'ml  0.835671
ocr res :'7'  0.356689
ocr res :【产品编号】：YM'-'X'-''3''0''1''1''0'.'9''6''8''9''9'  0.993695
ocr res :'6'  0.214355
ocr res :'0'.'9''9''5'  0.478052
ocr res :【品名】：纯臻营养护发素  0.996175
ocr res :'5'  0.594727
ocr res :  0
ocr res :'0'.'9''8''5'  0.55166
ocr res :【品牌】：代加工方式/'0'EMODM  0.917768
ocr res :每瓶'2''2'元，'1''0''0''0'瓶起订）  0.974644
ocr res :'0'.'9''9''3''9''7''6'  0.736755
ocr res :'3'  0.486572
ocr res :（'4''5'元/每公斤，'1''0''0'公斤起订）  0.940028
ocr res :'0'.'9'm'7'  0.534668
ocr res :'2'  0.961426
ocr res :  0
ocr res :'0'.'9''9''2'  0.524121
ocr res :产品信息/参数  0.913853
ocr res :纯臻营养护发素'0'.'9''9''3''6''0''4'  0.964128
ocr res :'0'  0.380127
ocr res :The detection visualized imagesavedin./vis.jpg  0.94302
[Time info] elapsed: 389 ms
```
### 精度

无

## 应用场景
图片文字提取，票据扫描、工业铭牌识别等

### 算法类别

OCR

### 热点应用行业

制造,政府,医疗,科研,交通,教育

## 源码仓库及问题反馈
https://developer.sourcefind.cn/codes/modelzoo/ppocrv5_migraphx
 

## 参考资料

 https://zhuanlan.zhihu.com/p/43534801

