#include "ocr_engine.hpp"

using namespace ppocr;
 
int main(int argc, char** argv)
{
    std::string det_model_onnx = "../Resource/Models/ppocrv5_server_det_infer.onnx";
    std::string rec_model_onnx = "../Resource/Models/ppocrv5_server_rec_infer.onnx";
    std::string img_path = "../Resource/Images/20250703205038.png";
    std::string character_dict_path = "../Resource/ppocr_keys_v5.txt";
    float segm_thres=0.3;
    float box_thresh=0.3; 
    ppOcrEngine ocr_engine(det_model_onnx,
        rec_model_onnx,
        character_dict_path,
        segm_thres,
        box_thresh,
        true,
        "fp32");
       
    cv::Mat img=cv::imread(img_path);
    ocr_engine.forward(img);
    return 0;
}
 