# Paddle Ocr v5

## 论文
A Practical Ultra Lightweight OCR System

- https://arxiv.org/pdf/2009.09941

## 模型结构
详细结构通过netron（ https://netron.app/ ） 查看
- DBNet
 ![alt text](Doc/Images/DBNet.png)

- CRNN
![alt text](Doc/Images/CRNN.png)
## 算法原理

使用DBNet对字符区域进行分隔，并对分割后的二值图用Vatti Clipping算法对字符区域多边形简化处理，找到精确的字符区域，然后将精确的字符图片送入到CRNN网络，CRNN负责提取图片的特征，学习字符序列的上下文关系，输出是一个概率分布序列（每个时间步对应一个字符类别的概率分布），CTC 层是 CRNN 的核心组成部分之一，它解决了如何将 RNN 输出的不定长概率序列对齐到不定长的目标标签序列（即真实文本）的问题，将输出的概率序列解码为最终的文本字符串。
![alt text](Doc/Images/pipeline.png)

## 环境配置

### Docker（方法一）

拉取镜像：

```plaintext
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:5.0.0-ubuntu22.04-dtk25.04.1-py3.10
```

创建并启动容器：

```plaintext
docker run --shm-size 16g --network=host --name=ppocr_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/ppocr_migraphx:/home/ppocr_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```plaintext
cd ./docker
docker build --no-cache -t ppocrv5_migraphx:1.0 .

docker run --shm-size 16g --network=host --name=ppocr_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/ppocr_migraphx:/home/ppocr_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据需求上传所需图像，测试图片位于Resource/Image下

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

```python
# 进入ppocrv5 migraphx工程根目录
cd <ppocrv5_migraphx> 

# 进入示例程序目录
cd Python/

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
如果测试环境是离线环境，可手动安装需要的依赖，依赖的.whl文件存放在3rdParty/rbuild_depend目录下
```
运行示例程序：
```
python inference.py
```
offload_copy和precision_mode设置可参考[Tutorial_Python.md](Doc/Tutorial_Python.md)，在main中示例。

### C++版本推理

注意：当使用操作系统不一样时，CMakeList需要做相应的修改：

```
# ubuntu操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/

# centos操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/
```

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

#### 安装Opencv依赖

```python
cd <path_to_ppocrv5_migraphx>
sh ./3rdParty/InstallOpenCVDependences.sh
```


#### 安装OpenCV并构建工程

```
rbuild build -d depend
```

如果构建不成功可手动编译OpenCV，步骤如下：
- 进入到3rdParty下解压opencv，tar -xvzf opencv-3.4.11_mini.tar.gz
- 进入到opencv-3.4.11_mini目录下创建build目录，cd build
- 执行以下命令：
```
cmake -D CMAKE_BUILD_TYPE=RELEASE       -D CMAKE_INSTALL_PREFIX=./opencv_dep      -D INSTALL_C_EXAMPLES=ON       -D INSTALL_PYTHON_EXAMPLES=ON       -D OPENCV_GENERATE_PKGCONFIG=ON       -D BUILD_EXAMPLES=ON  -D OPENCV_EXTRA_MODULES_PATH=../modules/ ..
```
- 执行make -j8 && make install,编译的头文件和库目录存放在opencv_dep,将opencv_dep目录拷贝到3rdParty,并命名为opencv
#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

当操作系统是ubuntu系统时：

```
export LD_LIBRARY_PATH=<path_to_ppocrv5_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

当操作系统是centos系统时：

```
export LD_LIBRARY_PATH=<path_to_ppocrv5_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

```python
# 进入ppocrv5 migraphx工程根目录
cd <path_to_ppocrv5_migraphx> 

# 进入build目录
cd build/

#编译
cmake .. && make 
#运行
./ppOcrV5cd 
```

## result

### Python版本

输出结果中，每个值分别对应每个label的实际概率。

```
产品信息/参数, 0.954
发足够的滋养, 1.000
纯臻宫乔护发素, 0.883
花费了'0'.'4''5''7''3''3''5'秒, 0.993
【净含量】：'2''2''0'ml, 0.993
每瓶'2''2'元，'1''0''0''0'瓶起订）, 0.998
【品名】：纯臻营养护发素, 0.998
【品牌】：代加工方式/'0'EMODM, 0.968
糖、椰油酰胺丙基甜菜碱、泛醒, 0.997
【适用人群】：适合所有肤质, 0.998
【产品编号】：YM'-'X'-''3''0''1''1''0'.'9''6''8''9''9', 0.993
（'4''5'元/每公斤，'1''0''0'公斤起订）, 0.972
【主要成分】：鲸蜡硬脂醇、燕麦B'-'葡聚, 0.966
【主要功能】：可紧致头发磷层，从而达到, 0.994
即时持久改善头发光泽的效果，给干燥的头, 0.997
The detectionvisualizedimagsavedin./vis.jpg, 0.940
[Time info] elapsed:3.5736
```

### C++版本


```
ocr res :[生成一幅画，负向提示词为：画中不要出现人物。正负提示词结合会]
ocr res :[Text_encode_'2'.副文本编码器，补充描述性细节(如材质、光照、]
ocr res :[图片的准确性，过滤掉不需要的元素，例如正向提示词为：提示模型]
ocr res :[编码器特征融合提升模型的理解能力。]
ocr res :[正负 prompt 设置：正向 prompt 和负向 prompt 结合可以提升生成]
ocr res :[语义表示捕获提示词的基础含义和全局语境（如对象、动作），与副]
ocr res :[的图像不会发生变化，随机种子可以增加生成图像的多样性。]
ocr res :[Text_encode.主文本编码器，将prompt序列转换为一个综合的]
ocr res :[响初始噪声和生成结果的确定性，固定种子后，同一个prompt生成]
ocr res :[声转化为目标图像。]
ocr res :[随机数设置：随机数种子是控制生成过程随机性的关键参数，直接影]
ocr res :[Scheduler：调度器，控制图像生成，决定了如何逐步将随机噪]
ocr res :[程和图像生成过程中有着至关重要的作用。]
ocr res :[在stable'-'dffusion'-'xl'-'base'-''1'.'0'模型中主要包含一下子组件：]
ocr res :[Pipeline的配置参数控制图像生成的质量和速度，在扩散模型预测过]
ocr res :[具配置文件中的定义手动加载各个子组件。]
ocr res :[这里使用了扩散模型加载器统一加载了所有的子组件，也可以更]
ocr res :[·'2'.'3'pipeline 配置]
Time taken by task: 3475 ms
```

### 精度

无

## 应用场景
图片文字提取，票据扫描、工业铭牌识别等

### 算法类别

OCR

### 热点应用行业

制造,政府,医疗,科研,交通,教育

## 源码仓库及问题反馈
https://developer.sourcefind.cn/codes/modelzoo/ppocrv5_migraphx
 

## 参考资料

 https://zhuanlan.zhihu.com/p/43534801

