# PowerFlowNet_pytorch
## 论文
`PowerFlowNet: Power flow approximation using message passing Graph Neural Networks`
- https://www.sciencedirect.com/science/article/pii/S0142061524003338

## 模型结构
利用消息传递图神经网络进行高质量电力流近似计算。

与现有的 PF GNN 方法相比，PowerFlowNet 的独特之处在于它巧妙地利用了消息传递 GNN 和高阶 GCN 的功能，并以一种名为 PowerFlowConv 的独特方式组合使用，以处理网络图的可训练掩码嵌入。这种创新方法使 PowerFlowNet 具有极高的扩展性，为 PF 问题提供了一种有效的解决方案。
<div align=center>
    <img src="./doc/arch_PF.png"/>
</div>

## 算法原理
PowerFlowNet 将潮流问题转化为一个图神经网络节点回归问题，它将每个母线表示为一个节点，将每条输电线路表示为一条边，同时保持网络的连通性。
<div align=center>
    <img src="./doc/arch_PF1.png"/>
</div>

## 环境配置
### 硬件需求
DCU型号：K100_AI,节点数量：1台,卡数：1张。
### Docker（方法一）
```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.10

docker run -it --name {docker_name} --device=/dev/kfd --privileged --network=host --device=/dev/dri --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --group-add video --shm-size 64G 12a8aef969d2 bash

cd /your_code_path/powerflownet_pytorch
pip install -r requirements.txt
```

### Dockerfile（方法二）
此处提供dockerfile的使用方法
```bash
cd docker
docker build --no-cache -t powerflownet:latest .
docker run -it --name {docker_name} --device=/dev/kfd --privileged --network=host --device=/dev/dri --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal:/opt/hyhal:ro --group-add video --shm-size 64G {imageID} bash

cd /your_code_path/powerflownet_pytorch
pip install -r requirements.txt
```
### Anaconda（方法三）
关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。
```bash
DTK: 25.04
python: 3.10
torch: 2.4.1+das.opt1.dtk25041
```
`Tips：以上dtk驱动、torch等DCU相关工具版本需要严格一一对应`

其它非深度学习库安装方式如下：
```bash
pip install -r requirements.txt
```

## 数据集
下载后解压到 ./powerflownet_pytorch/data/raw/ 文件夹
- https://surfdrive.surf.nl/files/index.php/s/Qw4RHLvI2RPBIBL

## 训练
```bash
python3 train.py --cfg_json ./configs/standard.json\
                --num-epochs 10\
                --data-dir ./data/
                --batch-size 128\
                --train_loss_fn mse_loss\
                --lr 0.001\
                --case 118v2\
                --model MaskEmbdMultiMPN\
                --save
```
## 推理
暂无
## result
详见./res 文件夹
### 精度
DCU(K100_AI)与GPU(A800)训练powerflownet精度一致，框架：pytorch

## 应用场景
### 算法类别
`图神经网络`
### 热点应用行业
`制造,电力,教育`
## 预训练权重
- [PowerFlowNet](https://surfdrive.surf.nl/files/index.php/s/iunfVTGsABT5NaD)
## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/powerflownet_pytorch
## 参考资料
- https://github.com/StavrosOrf/PoweFlowNet