from PIL import Image
from glob import glob
from pathlib import Path
from tqdm import tqdm

import os



def main(args):
    
    if not os.path.exists(args.tgt_folder):
        os.makedirs(args.tgt_folder)
    
    print("图像转换")
    for ipath in tqdm(glob(f"{args.src_folder}/*.png")):
        image = Image.open(ipath)
        
        tgt_name = Path(ipath).resolve().name.replace("png", "jpg")
        
        image.save(os.path.join(args.tgt_folder, tgt_name), "JPEG")
    print("图像转换完成")


if __name__ == "__main__":
    import argparse
    
    parser = argparse.ArgumentParser()
    
    parser.add_argument("--src_folder", type=str, help="")
    
    parser.add_argument("--tgt_folder", type=str, help="")

    args = parser.parse_args()
    
    main(args)