# Pix2pixHD
## 模型介绍
Pix2pixHD是一种图像到图像的转换模型，它可以将输入图像转换成一种特定的输出图像。这种模型的应用非常广泛，例如将草图转换成真实的图片、将低分辨率图片转换成高分辨率图片、将黑白图像转换成彩色图像等等。
## 模型结构
模型整体的结构是conditional GAN。 模型与Pix2pix相比更换了coarse-to-fine的生成器、multi-scale的判别器。

## 数据集
模型使用数据为cityscapes

<https://www.cityscapes-dataset.com/> 


## 训练及推理
### 环境配置
python依赖安装：

    torch==1.10.0a0+git2040069.dtk2210
    torchvision==0.11.0+cu102
### 训练
训练命令：

以 1024 x 512 分辨率训练模型 ( `bash ./scripts/train_512p.sh`)：

```
#!./scripts/train_512p.sh
python train.py --name label2city_512p
```


### 测试
测试命令：

测试模型（`bash ./scripts/test_1024p.sh`）：

    #!./scripts/test_1024p.sh
    python test.py --name label2city_1024p \
                   --netG local \
                   --ngf 32 \
                   --resize_or_crop none \



## 源码仓库及问题反馈
* [https://github.com/NVIDIA/pix2pixHD](https://github.com/NVIDIA/pix2pixHD)
## 参考
* [https://github.com/NVIDIA/pix2pixHD](https://github.com/NVIDIA/pix2pixHD)

