# PIX2PIXHD

## 论文

` High-Resolution Image Synthesis and Semantic `

- https://arxiv.org/pdf/1711.11585.pdf

## 模型结构
模型整体的结构是conditional GAN。 模型与Pix2pix相比更换了coarse-to-fine的生成器、multi-scale的判别器。

![](https://developer.hpccube.com/codes/modelzoo/pix2pixhd_pytorch/-/raw/master/doc/Pix2PixHD-GAN-model-for-paired-image-to-image-translation.png)

## 算法原理

 pix2pixHD的算法原理是基于条件生成对抗网络（Conditional Generative Adversarial Nets）。它是一个由两个部分组成的网络：生成器和判别器。生成器用于从训练数据中合成图像，而判别器则负责判断生成的图像是否真实。 

![](https://developer.hpccube.com/codes/modelzoo/pix2pixhd_pytorch/-/raw/master/doc/pix2pixHD原理.png)

## 环境配置

### Docker（方法一）

此处提供[光源](https://sourcefind.cn/#/main-page)拉取docker镜像

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py37-latest
docker run -it --network=host --name=pix2pixhd --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=32G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.10.0-centos7.6-dtk-22.10-py37-latest
pip install -r requirements.txt
```

### Dockerfile（方法二）

dockerfile使用方法

```
docker build --no-cache -t pix2pixhd:latest .
docker run -dit --network=host --name=pix2pixhd --privileged --device=/dev/kfd --device=/dev/dri --ipc=host --shm-size=16G  --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root --ulimit stack=-1:-1 --ulimit memlock=-1:-1 pix2pixhd:latest
docker exec -it pix2pixhd /bin/bash
```

### Anaconda（方法三）

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。

```
DTK驱动：dtk22.10
python：python3.7
apex==0.1+gitdb7007a.dtk2210
torch==1.10.0a0+git2040069.dtk2210
torchvision==0.10.0a0+e04d001.dtk2210
```

`Tips：以上dtk驱动、python等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：

```
pip install -r requirements.txt
pip install numpy pillow==9.5.0 scipy
```

## 数据集

`模型使用数据为cityscapes`

- <https://www.cityscapes-dataset.com/>

项目中已提供用于试验训练的迷你数据集，训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：

```
 ── dataset
 ────── cityscapes
       │   ├── train_label
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
       │   └── train_inst
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
       │   └── train_img
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
       │   └── test_label
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
       │   └── test_inst
       │             ├── xxx.png
       │             ├── xxx.png
       │             └── ...
```




## 训练
### 单机单卡

以 1024 x 512 分辨率训练模型

```
#!./scripts/train_512p.sh
python train.py --name label2city_512p
```

### 单机多卡

```
#!./scripts/train_512p.sh
python train.py --name label2city_512p --batchSize 4 --gpu_ids 0,1,2,3
```

## 推理

    python test.py --name label2city_512p \
                   --netG local \
                   --ngf 32 \
                   --resize_or_crop none \

## result

测试图

![](https://developer.hpccube.com/codes/modelzoo/pix2pixhd_pytorch/-/raw/master/doc/face1_1.jpg) )

### 精度

测试数据：<https://www.cityscapes-dataset.com/>，使用的加速卡:Z100L。

根据测试结果情况填写表格：

| pix2pixHD  | G_GAN | G_GAN_Feat | G_VGG | D_fake | D_real |
| :--------: | :---: | ---------- | ----- | ------ | :----: |
| cityscapes | 0.540 | 6.153      | 3.087 | 0.534  | 0.424  |

## 应用场景

### 算法类别

`图像超分`

### 热点应用行业

`设计`,`交通`,`网安`

## 源码仓库及问题反馈

* [https://developer.hpccube.com/codes/modelzoo/pix2pixhd_pytorch](https://developer.hpccube.com/codes/modelzoo/pix2pixhd_pytorch)
## 参考资料
* [https://github.com/NVIDIA/pix2pixHD](https://github.com/NVIDIA/pix2pixHD)

