# 简介

Pix2pixHD是一种图像到图像的转换模型，它可以将输入图像转换成一种特定的输出图像。这种模型的应用非常广泛，例如将草图转换成真实的图片、将低分辨率图片转换成高分辨率图片、将黑白图像转换成彩色图像等等。

Pix2pixHD是pix2pix的改进版，它在分辨率、视觉质量、视觉一致性和训练效率等方面都有所提高。Pix2pixHD引入了多尺度判别器，这样可以捕捉到不同尺度的全局和局部信息，提高了图像质量。此外，Pix2pixHD还使用了语义分割，可以将输入图像分解成不同的区域并对其进行处理，从而提高了模型的视觉一致性。

# 测试流程

## 安装工具包

pytorch1.10版本[1.10.0a0+git2040069-dtk2210]

## 加载环境变量

```
export PATH={PYTHON3_install_dir}/bin:$PATH

export LD_LIBRARY_PATH={PYTHON3_install_dir}/lib:$LD_LIBRARY_PATH
```

## 下载数据集

数据集下载地址：cityscapes

<https://www.cityscapes-dataset.com/> 

## 修改配置文件

options/base_options.py

```python
self.parser.add_argument('--checkpoints_dir', type=str, default='/../', help='models are saved here')


self.parser.add_argument('--dataroot', type=str, default='/../pix2pixHD/datasets/cityscapes')
```



# 运行指令

## 训练模型

以 1024 x 512 分辨率训练模型 ( `bash ./scripts/train_512p.sh`)：

```
#!./scripts/train_512p.sh
python train.py --name label2city_512p
```

## 测试

- 该文件夹中包含一些示例 Cityscapes 测试图像`datasets`。
- [请从这里](https://drive.google.com/file/d/1h9SykUnuZul7J3Nbms2QGH1wa85nbN2-/view?usp=sharing)（谷歌驱动器链接）下载预训练的 Cityscapes 模型，并将其放在`./checkpoints/label2city_1024p/`
- 测试模型（`bash ./scripts/test_1024p.sh`）：

```
#!./scripts/test_1024p.sh
python test.py --name label2city_1024p --netG local --ngf 32 --resize_or_crop none
```

测试结果将保存到此处的 html 文件中：`./results/label2city_1024p/test_latest/index.html`。

# 参考

[https://github.com/NVIDIA/pix2pixHD](https://github.com/NVIDIA/pix2pixHD)