# PASD

## 论文

`Pixel-Aware Stable Diffusion for Realistic Image Super-Resolution and Personalized Stylization`

* https://arxiv.org/pdf/2308.14469

## 模型结构

该模型基于`stable diffusion`结构，并在此基础上添加了`Degradation Removal`，`PACA`以及`ANS`模块。

![alt text](readme_imgs/model.png)

## 算法原理

该算法基于`stable diffusion`，通过增加`PACA`模块使用`cross-attention`的方式将`ControlNet`的特征与`Unet`的特征融合，保留了图像的细节特征。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

    docker run --shm-size 50g --network=host --name=pasd --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    python setup.py install

    cd BasicSR && python setup.py install


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 50g --network=host --name=pasd --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

    python setup.py install

    cd BasicSR && python setup.py install

### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk24.04.1
    python：python3.10
    torch: 2.1.0
    torchvision: 0.16.0

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install -r requirements.txt

    python setup.py install

    cd BasicSR && python setup.py install

## 数据集

无 

## 训练

无

## 推理

```bash
export HF_ENDPOINT=https://hf-mirror.com
```

### stable diffusion v1-5

### webui
```bash
python gradio_pasd.py
```

### 命令行

```bash
python test_pasd.py --image_path <path or folder> --output_dir <path/to/output_dir>
```

### sdxl

```bash
python test_pasd_sdxl.py --image_path <path/to/image/folder or path> --output_dir <path/to/save/folder>
```

注意：sdxl版本功能较少但性能较好。

## result

|模型|输入|输出|
|:---:|:---:|:---:|
|SD1.5|<img src="readme_imgs/d4f59e89c1011bc4.png">|<img src="readme_imgs/d4f59e89c1011bc4_15.png">|
|SDXL|<img src="readme_imgs/d4f59e89c1011bc4.png">|<img src="readme_imgs/d4f59e89c1011bc4_sdxl.png" style="zoom:50%;">|


### 精度

无

## 应用场景

### 算法类别

`图像超分`

### 热点应用行业

`电商,绘画,交通`

## 预训练权重

```bash
cd pasd/annotator/ckpts && wget https://public-vigen-video.oss-cn-shanghai.aliyuncs.com/robin/models/RetinaFace-R50.pth
```

### stable diffusion v1-5

- base_model: [huggingface](https://hf-mirror.com/benjamin-paine/stable-diffusion-v1-5/tree/main) | [SCNet]

- pasd: [huggingface](https://hf-mirror.com/yangtao9009/PASD/tree/main/pasd) | [SCNet]
- pasd_light: [原链接](https://public-vigen-video.oss-cn-shanghai.aliyuncs.com/robin/models/PASD/pasd_light.zip) | [SCNet]
- pasd_rrdb: [原链接](https://public-vigen-video.oss-cn-shanghai.aliyuncs.com/robin/models/PASD/pasd_rrdb.zip) | [SCNet]
- pasd_light_rrdb: [原链接](https://public-vigen-video.oss-cn-shanghai.aliyuncs.com/robin/models/PASD/pasd_light_rrdb.zip) | [SCNet]

- dreambooth_lora
    - toonyou_beta6: [huggingface](https://huggingface.co/frankjoshua/toonyou_beta6/tree/main) | [SCNet]

|模型名称|存储路径|
|:---:|:---:|
|base_model|checkpoints/stable-diffusion-v1-5|
|pasd*|runs/*|
|dreambooth_lora|checkpoints/personalized_models/*.safetensors|

注意：上述模型都需要下载`.safetensors`版本。


### sdxl

- pasd_sdxl: [huggingface](https://hf-mirror.com/yangtao9009/PASD-SDXL/tree/main) | [SCNet]

- stable-diffusion-xl-base-1.0: [huggingface](https://hf-mirror.com/stabilityai/stable-diffusion-xl-base-1.0) | [SCNet]

- stable-diffusion-xl-refiner-1.0: [huggingface](https://hf-mirror.com/stabilityai/stable-diffusion-xl-refiner-1.0) | [SCNet]

- sdxl-vae-fp16-fix: [huggingface](https://hf-mirror.com/madebyollin/sdxl-vae-fp16-fix) | [SCNet]


|模型名称|存储路径|
|:---:|:---:|
|base_model|checkpoints/stable-diffusion-xl-base(refiner)-1.0|
|pasd_sdxl|runs/pasd_sdxl|
|vae|checkpoints/sdxl-vae-fp16-fix|

注意：上述模型都需要下载`.safetensors`版本。

## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/pasd_pytorch

## 参考资料

* https://github.com/yangxy/PASD/tree/main

