# ParticleNet

## 论文

`Jet Tagging via Particle Clouds`

* https://arxiv.org/pdf/1902.08570

## 模型结构

本项目使用ParticleNet(Lite)，包含 EdgeConv 操作进行卷积，该操作能够利用粒子云的局部空间结构，并保持置换不变性。模型包含多个 EdgeConv 块，每个块使用不同数量的邻居和通道数，以学习不同尺度的特征。

<img src="readme_imgs/arch.png" style="zoom:70%">

## 算法原理

该算法将喷注视为“粒子云”，即无序的粒子集合。 它利用 EdgeConv 操作和动态图更新方法，有效地提取粒子云的局部空间结构和特征，从而实现对喷注的准确分类。


## 环境配置

注意：所有文件均在`tf-keras`目录下。

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/tensorflow:2.13.1-py3.10-dtk24.04.3-ubuntu20.04

    docker run --shm-size 50g --network=host --name=particlenet --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 50g --network=host --name=particlenet --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt


## 数据集

仅在tf-keras目录下可用

[zenodo](https://zenodo.org/records/2603256) | [SCNet高速下载通道](http://113.200.138.88:18080/aidatasets/project-dependency/top-quark-tagging)

数据存储结构
```
original/
├── test.h5
├── train.h5
└── val.h5
```

运行`convert_dataset.py`对数据进行处理，处理后，

```
converted/
├── test_file_0.awkd
├── train_file_0.awkd
└── val_file_0.awkd
```

<!-- 提示：执行下述命令启动服务，`jupyter notebook --no-browser --ip=0.0.0.0 --allow-root` -->

## 训练

```bash
python keras_train.py
```

## 推理

```bash
python predict_demo.py
```

注意：代码仅提供简单的推理测试，需根据需求进行修改。

## result

无

### 精度

所有结果均使用项目中的默认参数训练得到.

||val_acc|
|:---:|:---:|
|k100ai|0.9229|
|gpu|0.9145|

## 应用场景

### 算法类别

`ai for science`

### 热点应用行业

`高能物理,医疗,金融`


## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/particlenet_tensorflow

## 参考资料

* https://github.com/hqucms/ParticleNet

