#include <VLPR.h>
#include <SimpleLog.h>

namespace migraphxSamples
{
VLPR::VLPR() {}

VLPR::~VLPR() { configurationFile.release(); }

ErrorCode VLPR::Initialize(InitializationParameterOfDB initParamOfDB,
                           InitializationParameterOfSVTR initParamOfSVTR)
{
    // 初始化DB
    initParamOfDB.configFilePath = CONFIG_FILE;
    ErrorCode errorCode          = db.Initialize(initParamOfDB);
    if(errorCode != SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize db!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize db\n");

    // 初始化SVTR
    initParamOfSVTR.configFilePath = CONFIG_FILE;
    errorCode                      = svtr.Initialize(initParamOfSVTR);
    if(errorCode != SUCCESS)
    {
        LOG_ERROR(stdout, "fail to initialize svtr!\n");
        exit(-1);
    }
    LOG_INFO(stdout, "succeed to initialize svtr\n");
    return SUCCESS;
}

ErrorCode
VLPR::Infer(cv::Mat& img, std::vector<std::string>& recTexts, std::vector<float>& recTextScores)
{
    // DB推理
    db.Infer(img, imgLists);

    for(int i = 0; i < imgLists.size(); i++)
    {
        float maxWHRatio = float(imgLists[i].cols) / float(imgLists[i].rows);

        // SVTR推理
        svtr.Infer(imgLists[i], recText, recTextScore, maxWHRatio);
        recTexts.push_back(recText);
        recTextScores.push_back(recTextScore);
    }

    return SUCCESS;
}

} // namespace migraphxSamples