# PaddleOCR车牌识别

## 模型介绍

车牌识别(Vehicle License Plate Recognition，VLPR) 是计算机视频图像识别技术在车辆牌照识别中的一种应用。车牌识别技术要求能够将运动中的汽车牌照从复杂背景中提取并识别出来，在高速公路车辆管理，停车场管理和城市交通中得到广泛应用。PaddleOCR车牌识别包括本文检测和文本识别两部分内容，其中使用DBnet作为文本检测模型，SVTR作为文本识别模型。车牌识别过程：输入->图像预处理->文字检测->文本识别->输出。

## 模型结构

DBnet是一种基于分割的文本检测方法，相比传统分割方法需要设定固定阈值，该模型将二值化操作插入到分割网络中进行联合优化，通过网络学习可以自适应的预测图像中每一个像素点的阈值，能够在像素水平很好的检测自然场景下不同形状的文字。SVTR是一种端到端的文本识别模型，通过单个视觉模型就可以一站式解决特征提取和文本转录两个任务，同时也保证了更快的推理速度。百度PaddleOCR开源项目提供了车牌识别的预训练模型，本示例使用PaddleOCR提供的蓝绿黄牌识别模型进行推理。

## Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

### 下载镜像

在光源可拉取推理的docker镜像，PaddleOCR工程推荐的镜像如下：

```python
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```

### 设置Python环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

### 安装依赖

```
# 进入python示例目录
cd <path_to_paddleocr_migraphx>/Python

# 安装依赖
pip install -r requirements.txt
```

### 运行示例

依赖安装成功之后，可在当前目录执行如下指令运行程序推理：

```
# 开启环境变量
export MIGRAPHX_DYNAMIC_SHAPE=1

# 运行示例程序
python PaddleOCR_infer_migraphx.py
```

PaddleOCR车牌识别结果为：

```
皖AD19906
```

## C++版本推理

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。

### 下载镜像

在光源中下载MIGraphX镜像： 

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort1.14.0_migraphx3.0.0-dtk22.10.1
```


### 构建工程

```
rbuild build -d depend
```

### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

```
export LD_LIBRARY_PATH=<path_to_paddleocr_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

### 运行示例

成功编译PaddleOCR车牌识别工程后，执行如下命令运行该示例：

```
# 进入paddleocr migraphx工程根目录
cd <path_to_paddleocr_migraphx> 

# 进入build目录
cd ./build/

# 开启环境变量
export MIGRAPHX_DYNAMIC_SHAPE=1

# 运行示例
./PaddleOCR_VLPR
```

PaddleOCR车牌识别结果为：

```
皖AD19906
```

## 源码仓库及问题反馈

​		https://developer.hpccube.com/codes/modelzoo/paddleocr_migraphx

## 参考

​		https://github.com/PaddlePaddle/PaddleOCR
