#include <Sample.h>
#include <opencv2/dnn.hpp>
#include <SimpleLog.h>
#include <Filesystem.h>
#include <VLPR.h>
#include <fstream>


using namespace std;
using namespace cv;
using namespace cv::dnn;
using namespace migraphx;
using namespace migraphxSamples;


void Sample_VLPR()
{
    // 创建PaddleOCR车牌识别
    VLPR vlpr;
    InitializationParameterOfDB initParamOfDB; 
    InitializationParameterOfSVTR initParamOfSVTR;
    vlpr.Initialize(initParamOfDB, initParamOfSVTR);

    // 读取测试图片
    cv:: Mat Image=cv::imread("../Resource/Images/vlpr.jpg", 1);

    // 推理
    std::vector<std::string> recTexts;
    std::vector<float> recTextScores;
    double time1 = getTickCount();
    vlpr.Infer(Image, recTexts, recTextScores); 
    double time2 = getTickCount();
    double elapsedTime = (time2 - time1)*1000 / getTickFrequency();
    LOG_INFO(stdout, "inference time:%f ms\n", elapsedTime);

    // 打印结果
    for (int i = 0; i < recTexts.size(); i++) 
    {
        printf("VLPR Result:[%s, %f]\n", recTexts[i].c_str(), recTextScores[i]);
    }
}