// PaddleOCR车牌识别

#ifndef __OCR_SVTR_H__
#define __OCR_SVTR_H__

#include <string>
#include <migraphx/program.hpp>
#include <opencv2/opencv.hpp>
#include <CommonDefinition.h>

using namespace std;
using namespace cv;
using namespace migraphx;

namespace migraphxSamples
{

class SVTR
{
public:
    SVTR();

    ~SVTR();

    ErrorCode Initialize(InitializationParameterOfSVTR InitializationParameterOfSVTR);

    ErrorCode Infer(cv::Mat &img, std::string &resultsChar, float &resultsdScore, float &maxWHRatio);

private:
    ErrorCode DoCommonInitialization(InitializationParameterOfSVTR InitializationParameterOfSVTR);

private:
    cv::FileStorage configurationFile;
    InitializationParameterOfSVTR initializationParameter;
    FILE *logFile;

    migraphx::program net;
    cv::Size inputSize;
    string inputName;
    migraphx::shape inputShape;
    string dictPath;
    std::vector<std::string> charactorDict;

};
}

#endif