#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <SimpleLog.h>
#include <Filesystem.h>
#include <VLPR.h>
#include <fstream>

int main()
{
    // 创建PaddleOCR车牌识别
    migraphxSamples::VLPR vlpr;
    migraphxSamples::InitializationParameterOfDB initParamOfDB; 
    migraphxSamples::InitializationParameterOfSVTR initParamOfSVTR;
    vlpr.Initialize(initParamOfDB, initParamOfSVTR);

    // 读取测试图片
    cv:: Mat Image=cv::imread("../Resource/Images/vlpr.jpg", 1);

    // 推理
    std::vector<std::string> recTexts;
    std::vector<float> recTextScores;
    vlpr.Infer(Image, recTexts, recTextScores); 

    // 打印结果
    for (int i = 0; i < recTexts.size(); i++) 
    {
        printf("VLPR Result:%s\n", recTexts[i].c_str());
    }
}