# PaddleOCR车牌识别

## 模型介绍

车牌识别(Vehicle License Plate Recognition，VLPR) 是计算机视频图像识别技术在车辆牌照识别中的一种应用。车牌识别技术要求能够将运动中的汽车牌照从复杂背景中提取并识别出来，在高速公路车辆管理，停车场管理和城市交通中得到广泛应用。PaddleOCR车牌识别包括本文检测和文本识别两部分内容，其中使用DBnet作为文本检测模型，SVTR作为文本识别模型。车牌识别过程：输入->图像预处理->文字检测->文本识别->输出。

## 模型结构

DBnet是一种基于分割的文本检测方法，相比传统分割方法需要设定固定阈值，该模型将二值化操作插入到分割网络中进行联合优化，通过网络学习可以自适应的预测图像中每一个像素点的阈值，能够在像素水平很好的检测自然场景下不同形状的文字。SVTR是一种端到端的文本识别模型，通过单个视觉模型就可以一站式解决特征提取和文本转录两个任务，同时也保证了更快的推理速度。百度PaddleOCR开源项目提供了车牌识别的预训练模型，本示例使用PaddleOCR提供的蓝绿黄牌识别模型进行推理。

## 推理

### 环境配置

在[光源](https://www.sourcefind.cn/#/image/dcu/custom)可拉取用于推理的docker镜像，PaddleOCR车牌识别模型推理推荐的镜像如下：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:ort_dcu_1.14.0_migraphx2.5.2_dtk22.10.1
```

在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载MIGraphX安装包，python依赖安装：

```
pip install -r requirements.txt
```

注意：PaddleOCR车牌识别使用动态shape推理，需要MIGraphX版本>=2.5.2。

### 运行示例

PaddleOCR车牌识别的推理示例程序是PaddleOCR_infer_migraphx.py，使用如下命令运行该推理示例：

```
# 设置动态shape模式
export MIGRAPHX_DYNAMIC_SHAPE=1

# 运行示例
python PaddleOCR_infer_migraphx.py
```

车牌识别结果为：

```
[[('皖AD19906', 0.98606485)]]
```

## 历史版本

​		https://developer.hpccube.com/codes/modelzoo/paddleocr_migraphx

## 参考

​		https://github.com/PaddlePaddle/PaddleOCR
