# PaddleOCR

## 论文

PaddleOCR通过det、rec、cls三个模型分别实现字符检测、字符识别和字符方向分类的应用

det模型主要用DB算法，参考论文如下：

https://arxiv.org/pdf/1911.08947.pdf

rec模型主要用SVTR算法，参考论文如下：

https://arxiv.org/pdf/2205.00159.pdf

## 模型结构

det：

<img src="./Doc/Images/dbnet-arc.png" style="zoom:100%;" align=middle>

rec：

<img src="./Doc/Images/SVTR-arc.png" style="zoom:100%;" align=middle>

## 算法原理

百度PaddleOCR开源项目提供了车牌识别的预训练模型，本示例使用PaddleOCR提供的蓝绿黄牌识别模型进行推理。其中，DBnet是一种基于分割的文本检测方法，相比传统分割方法需要设定固定阈值，该模型将二值化操作插入到分割网络中进行联合优化，通过网络学习可以自适应的预测图像中每一个像素点的阈值，能够在像素水平很好的检测自然场景下不同形状的文字。SVTR是一种端到端的文本识别模型，通过单个视觉模型就可以一站式解决特征提取和文本转录两个任务，同时也保证了更快的推理速度。

<img src="./Doc/Images/paddleocr.png" style="zoom:100%;" align=middle>

## 环境配置

### Docker（方法一）

拉取镜像：

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.3.0-ubuntu20.04-dtk24.04.1-py3.10
```

创建并启动容器：

```
docker run --shm-size 16g --network=host --name=paddleocr_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/paddleocr_migraphx:/home/paddleocr_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

### Dockerfile（方法二）

```
cd ./docker
docker build --no-cache -t paddleocr_migraphx:2.0 .

docker run --shm-size 16g --network=host --name=paddleocr_migraphx --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v $PWD/paddleocr_migraphx:/home/paddleocr_migraphx -v /opt/hyhal:/opt/hyhal:ro -it <Your Image ID> /bin/bash

# 激活dtk
source /opt/dtk/env.sh
```

## 数据集

根据输入的样本图像，进行车牌识别。

## 推理

### Python版本推理

下面介绍如何运行Python代码示例，Python示例的详细说明见Doc目录下的Tutorial_Python.md。

#### 设置环境变量

```
export PYTHONPATH=/opt/dtk/lib:$PYTHONPATH
```

#### 运行示例

```
# 进入python示例目录
cd <path_to_paddleocr_migraphx>/Python

# 安装依赖
pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple

# 运行示例
python PaddleOCR_infer_migraphx.py
```

### C++版本推理

注意：当使用操作系统不一样时，CMakeList需要做相应的修改：

```
# ubuntu操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/

# centos操作系统
${CMAKE_CURRENT_SOURCE_DIR}/depend/lib/ 修改为 ${CMAKE_CURRENT_SOURCE_DIR}/depend/lib64/
```

下面介绍如何运行C++代码示例，C++示例的详细说明见Doc目录下的Tutorial_Cpp.md。


#### 构建工程

```
rbuild build -d depend
```

#### 设置环境变量

将依赖库依赖加入环境变量LD_LIBRARY_PATH，在~/.bashrc中添加如下语句：

当操作系统是ubuntu系统时：

```
export LD_LIBRARY_PATH=<path_to_yolov3_migraphx>/depend/lib/:$LD_LIBRARY_PATH
```

当操作系统是centos系统时：

```
export LD_LIBRARY_PATH=<path_to_paddleocr_migraphx>/depend/lib64/:$LD_LIBRARY_PATH
```

然后执行:

```
source ~/.bashrc
```

#### 运行示例

成功编译PaddleOCR车牌识别工程后，执行如下命令运行该示例：

```
# 进入paddleocr migraphx工程根目录
cd <path_to_paddleocr_migraphx> 

# 进入build目录
cd ./build/

# 运行示例
./PaddleOCR_VLPR
```

## result

#### Python版本

输入样本图像，进行车牌识别：

<img src="./Doc/Images/vlpr.jpg" style="zoom:100%;" align=middle>

```
皖AD19906
```

#### C++版本

输入样本图像，进行车牌识别：

<img src="./Doc/Images/vlpr.jpg" style="zoom:100%;" align=middle>

```
皖AD19906
```

### 精度

无

## 应用场景

### 算法类别

`ocr`

### 热点应用行业

`金融`,`交通`,`教育`,`医疗`

## 源码仓库及问题反馈

https://developer.hpccube.com/codes/modelzoo/paddleocr_migraphx

## 参考资料

https://github.com/PaddlePaddle/PaddleOCR
