// PaddleOCR车牌识别
#ifndef __VLPR_H__
#define __VLPR_H__

#include <OcrDB.h>
#include <OcrSVTR.h>
#include <opencv2/opencv.hpp>
#include <CommonDefinition.h>

namespace migraphxSamples
{

class VLPR
{
public:
    VLPR();

    ~VLPR();

    ErrorCode Initialize(InitializationParameterOfDB initParamOfDB, InitializationParameterOfSVTR initParamOfSVTR);

    ErrorCode Infer(cv::Mat &img, std::vector<std::string> &recTexts, std::vector<float> &recTextScores);

private:
    DB db;
    SVTR svtr;
    cv::FileStorage configurationFile;
    std::vector<cv::Mat> imgLists; 
    std::string recText;
    float recTextScore;
       
};
}

#endif