# PaddleOCR
## 模型介绍
基于百度PaddleOCR的字符识别模型。
## 模型结构
整体包含检测和识别两个模型。
## 数据集
推荐使用icdar2015数据集[icdar2015](https://rrc.cvc.uab.es/?ch=4&com=downloads)。

检测模型训练集文件结构
```
/PaddleOCR/train_data/icdar2015/text_localization/
  └─ icdar_c4_train_imgs/         Training data of icdar dataset
  └─ ch4_test_images/             Testing data of icdar dataset
  └─ train_icdar2015_label.txt    Training annotation of icdar dataset
  └─ test_icdar2015_label.txt     Test annotation of icdar dataset
```
识别模型训练集文件结构
```
|-train_data
  |-rec
    |- rec_gt_train.txt
    |- train
        |- word_001.png
        |- word_002.jpg
        |- word_003.jpg
        | ...
    |-ic15_data
        |- rec_gt_test.txt
        |- test
            |- word_001.jpg
            |- word_002.jpg
            |- word_003.jpg
            | ...
```
## 训练及推理
### 环境配置
在[光源](https://www.sourcefind.cn/#/service-details)可拉取训练以及推理的docker镜像，在[光合开发者社区](https://cancon.hpccube.com:65024/4/main/)可下载paddle安装包。PaddleOCR推荐的镜像如下：
* 训练/推理镜像：docker pull image.sourcefind.cn:5000/dcu/admin/base/paddlepaddle:2.3.2-centos7.6-dtk-22.10.1-py37-latest

### 训练
以icdar2015数据集训练

检测模型
python3 -m paddle.distributed.launch --gpus '0,1,2,3'  tools/train.py -c configs/det/det_mv3_db.yml -o Global.pretrained_model=./pretrain_models/MobileNetV3_large_x0_5_pretrained

识别模型
python3 -m paddle.distributed.launch --gpus '0,1,2,3'  tools/train.py -c configs/rec/PP-OCRv3/en_PP-OCRv3_rec.yml -o Global.pretrained_model=en_PP-OCRv3_rec_train/best_accuracy

### 测试
检测模型
python3 -m paddle.distributed.launch --gpus '0,1,2,3'  tools/eval.py -c configs/det/det_mv3_db.yml -o Global.pretrained_model=./output/db_mv3/best_accuracy.pdparams

识别模型
python3 -m paddle.distributed.launch --gpus '0,1,2,3'  tools/eval.py -c configs/rec/PP-OCRv3/en_PP-OCRv3_rec.yml -o Global.pretrained_model=./v3_en_mobile/best_accuracy.pdparams

### 推理
python3 tools/infer/predict_system.py --image_dir="./doc/imgs/" --det_model_dir="./ch_PP-OCRv3_det_infer/" --rec_model_dir="./ch_PP-OCRv3_rec_infer/" --use_angle_cls=false --rec_image_shape=3,48,320 --warmup=1

## 性能和准确率数据

检测模型测试
| Model | Precision | Recall |
| :------: | :------: |:------: |
| det | 0.7054 | 0.7193  |

识别模型测试
| Model | Acc | 
| :------: | :------: |
| rec | 0.6490 | 

推理
| 图片 | 检测数/识别数 | 检测时间(ms) |识别时间(s) |
| :------: | :------: |:------: |:------: |
| 00006737.jpg | 38 | 0.1446 |0.1450 |
| 00009282.jpg | 13 | 0.1412 |0.0898 |
| 00015504.jpg | 74 | 0.1891 |0.2880 |
| 00018069.jpg | 69 | 0.1790 |0.1325 |
| 00056221.jpg | 19 | 0.1326 |0.1175 |
| 00057937.jpg | 50 | 0.1504 |0.1546 |
| 00059985.jpg | 24 | 0.1372 |0.1146 |
| 00077949.jpg | 20 | 0.1347 |0.0838 |
| 00111002.jpg | 33 | 0.1446 |0.1259 |
| 00207393.jpg | 4  | 0.1296 |0.0408 |
| 1.jpg        | 2  | 0.1227 |0.0290 |
| 11.jpg       | 16 | 0.1227 |0.0817 |
| 12.jpg       | 4  | 0.1129 |0.0284 |
| french_0.jpg | 11 | 0.1191 |0.0493 |
| ger_1.jpg    | 4  | 0.1127 |0.0277 |
| ger_2.jpg    | 3  | 0.1121 |0.0278 |
| japan_1.jpg  | 3  | 0.1113 |0.0277 |
| japan_2.jpg  | 59 | 0.1551 |0.1133 |
| korean_1.jpg | 6  | 0.1161 |0.0395 |
| model_prod_flow_ch.png | 11 | 0.1182 |0.0502 |
## 参考
* [PaddleOCR](https://github.com/PaddlePaddle/PaddleOCR)

