# PaddleOCR-VL-1.5
## 论文
暂无

## 模型简介
PaddleOCR-VL-1.5 是 PaddleOCR-VL 的下一代先进模型，在 OmniDocBench v1.5 基准上实现了 94.5% 的全新 SOTA（当前最优）准确率。 为严格评估模型在真实世界物理失真（包括扫描伪影、倾斜、扭曲、屏幕拍摄和光照变化）下的鲁棒性，我们提出了 Real5-OmniDocBench 基准。实验结果表明，该增强模型在新构建的基准上达到了 SOTA 性能。此外，我们在保持模型为 0.9B 超紧凑视觉语言模型（VLM）并具备高效率的同时，进一步扩展了其能力，新增了印章识别和文本检测任务。

PaddleOCR-VL-1.5 的核心能力
    1. 参数量仅为 0.9B，PaddleOCR-VL-1.5 在 OmniDocBench v1.5 上达到 94.5% 的准确率，超越了先前的 SOTA 模型 PaddleOCR-VL。在表格、公式和文本识别方面均取得显著提升。

    2. 通过支持不规则形状定位，引入了一种创新的文档解析方法，可在倾斜和扭曲的文档条件下实现精确的多边形检测。在五类真实场景（扫描、倾斜、扭曲、屏幕拍摄和光照变化）下的评测中，其性能均优于主流开源及闭源模型。

    3. 模型新增了文本检测（文本行定位与识别）以及印章识别功能，所有相关指标在其各自任务中均创下新的 SOTA 成绩。

    4. PaddleOCR-VL-1.5 进一步强化了在专业场景和多语言识别方面的能力。针对生僻字、古籍文本、多语言表格、下划线和复选框的识别性能得到提升，并将语言支持范围扩展至中国藏文和孟加拉语。

    5. 模型支持自动跨页表格合并和跨页段落标题识别，有效缓解了长文档解析中的内容碎片化问题。

<div align=center>
    <img src="./doc/PaddleOCR-VL-1.5.png"/>
</div>

## 环境依赖
- 列举基础环境需求，根据实际情况填写

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | 4.57.1 |
| vllm | 0.9.2+das.opt1.dtk25042 |
| paddlepaddle-dcu | 3.2.2 |
| paddlex | 3.4 |
| paddleocr | 3.3.3 |

推荐使用镜像: image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10

- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it \
    --shm-size 60g \
    --network=host \
    --name paddleocr-vl-1.5 \
    --privileged \
    --device=/dev/kfd \
    --device=/dev/dri \
    --device=/dev/mkfd \
    --group-add video \
    --cap-add=SYS_PTRACE \
    --security-opt seccomp=unconfined \
    -u root \
    -v /opt/hyhal/:/opt/hyhal/:ro \
    -v /path/your_code_data/:/path/your_code_data/ \
    image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包安装如下：
```
python -m pip install paddlepaddle-dcu==3.2.2 -i https://www.paddlepaddle.org.cn/packages/stable/dcu/
python -m pip install -U "paddleocr[doc-parser]"
pip install paddlex==3.4
```

## 数据集
暂无

## 训练
暂无

## 推理
### vllm
#### 单机推理
- 命令行
```bash
export PADDLE_PDX_DISABLE_DEV_MODEL_WL=1
export DISABLE_MODEL_SOURCE_CHECK=1

paddleocr doc_parser -i doc/paddleocr_vl_demo.png --device DCU --precision fp32 --save_path ./output
```

- 服务端方式
```bash
## server
paddlex_genai_server --model_name PaddleOCR-VL-1.5-0.9B --backend vllm --host 127.0.0.1 --port 8118 --model_dir PaddlePaddle/PaddleOCR-VL-1.5

## client
export PADDLE_PDX_DISABLE_DEV_MODEL_WL=1
export DISABLE_MODEL_SOURCE_CHECK=1
paddleocr doc_parser -i doc/paddleocr_vl_demo.png --vl_rec_backend vllm-server --vl_rec_server_url http://127.0.0.1:8118/v1 --device DCU --save_path ./output-vllm
```

## 效果展示
<div align=center>
    <img src="doc/paddleocr_vl_demo_layout_det_res.png"/>
</div>

<div align=center>
    <img src="doc/result-dcu.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：paddle。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| PaddleOCR-VL-1.5 | 1B | K100AI | 1 | [Modelscope](https://modelscope.cn/models/PaddlePaddle/PaddleOCR-VL-1.5) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/paddleocr-vl-1.5_paddle

## 参考资料
- https://github.com/PaddlePaddle/PaddleOCR