# PaCoRe
## 论文
[PaCoRe](https://github.com/stepfun-ai/PaCoRe/blob/main/pacore_report.pdf)

## 模型简介
PaCoRe（Parallel Coordinated Reasoning，并行协同推理）是一种将推理驱动力从顺序深度转向协同并行广度的框架，突破了模型上下文限制，并实现测试阶段计算资源的规模化扩展：  
- 并行思维探索：PaCoRe启动大规模并行探索路径；  
- 多轮协同整合：通过消息传递架构将并行思考压缩为精炼信息，并综合指导下一轮推理；  
- 基于结果的强化学习训练：通过大规模结果导向的强化学习训练，PaCoRe掌握了调和多元并行洞察所需的推理综合能力。  
该方法在多个领域实现显著性能提升，尤其在数学推理方面超越前沿系统：通过将有效测试时计算量扩展至约200万token，一个80亿参数的模型在HMMT2025基准测试中达到94.5%的准确率，超越GPT-5的93.2%。
<div align=center>
    <img src="./doc/perf.png"/>
</div>
## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

推荐使用镜像:image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name PaCoRe --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理

```bash
## serve启动
可参考vllm_serve.sh脚本
vllm serve stepfun-ai/PaCoRe-8B  --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1 --max-model-len 32768 --port 8010
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8010/v1/chat/completions"      -H "Content-Type: application/json"     --data '{
                "model": "stepfun-ai/PaCoRe-8B",
                "messages": [
                        {
                                "role": "user",
                                "content": "请介绍下自己"
                        }
                ]
        }'

```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| PaCoRe | 8B | K100AI | 1 | [下载地址](https://huggingface.co/stepfun-ai/PaCoRe-8B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/pacore_vllm

## 参考资料
- https://github.com/stepfun-ai/PaCoRe/tree/main
