# Ovis2.5
## 论文
[Ovis2.5 Technical Report](https://arxiv.org/abs/2508.11737)

## 模型简介
Ovis2.5专为原生分辨率视觉感知和增强的多模态推理而设计，在图像推理、视频理解和接地基准测试中表现出领先的性能，展现了强大的通用多模态能力。
它集成了一个原生分辨率视觉转换器 (NaViT)，能够以原始可变分辨率处理图像，
无需固定分辨率的平铺，即可同时保留精细细节和整体布局——这对于图表等视觉密集型内容至关重要。
为了增强推理能力，Ovis2.5 不仅基于线性思维链 (CoT) 进行训练，还基于反思性推理进行训练，包括自我检查和修正。
这种高级功能在推理阶段作为可选的思维模式提供，使用户能够以牺牲延迟为代价，换取对复杂输入更高的准确率。

<div align=center>
    <img src="./doc/Ovis25_arch.png"/>
</div>

## 环境依赖

|      软件      | 版本 |
|:------------:| :------: |
|     DTK      | 25.04.2 |
|    python    | 3.10.12 |
| transformers | 4.57.1 |
|    torch     | 2.5.1+das.opt1.dtk25042 |
| accelerate | 1.11.0 |
|  torchaudio   | 2.5.1+das.opt1.dtk25042 |

推荐使用镜像:
- 挂载地址`-v`，`{docker_name}`和 `{docker_image_name}`根据实际模型情况修改

```bash
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro {docker_image_name} bash

示例如下：
docker run -it --shm-size 200g --network=host --name ovis2.5 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_path/:/path/your_code_path/ -v /opt/hyhal/:/opt/hyhal/:ro image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装，其它包参照requirements.txt安装：
```
pip install -r requirements.txt
```

## 数据集
`暂无`

## 训练
`暂无`

## 推理

### transformers
#### 单机推理
```bash
HIP_VISIBLE_DEVICES=0 python ovis25_infer.py
```

## 效果展示
Input:
- images:
<div align=center>
    <img src="./doc/TIlymOb86R6_Mez3bpmcB.png"/>
</div>

- text: "Calculate the sum of the numbers in the middle box in figure (c)."

Output:
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
`DCU与GPU精度一致，推理框架：transformers。`

## 预训练权重
|    模型名称    | 权重大小 | DCU型号  | 最低卡数需求 |下载地址|
|:----------:|:----:|:----------:|:---------------------:|:----------:|
| Ovis2.5-2B |  2B  | BW1000| 1 | [Hugging Face](https://huggingface.co/AIDC-AI/Ovis2.5-2B) |
| Ovis2.5-9B |  9B  | BW1000| 1 | [Hugging Face](https://huggingface.co/AIDC-AI/Ovis2.5-9B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/ovis2.5_pytorch

## 参考资料
- https://github.com/AIDC-AI/Ovis
