# Ouro
## 论文
[Ouro](https://arxiv.org/pdf/2510.25741)

## 模型简介
Ouro-1.4B基于Transformer架构中的解码器，主要特点如下：
- 卓越的参数效率：仅用1.4B参数即可匹配3-4B标准transformer的性能
- 迭代潜空间推理：在潜空间中通过递归计算进行推理
- 自适应计算：支持早期退出机制以实现动态计算分配
模型架构如下：  

| 配置 | 值 |
| :------: | :------: |
| 参数 | 1.4B |
| 层数 | 24 |
| 循环步骤 | 4 |
| 隐藏层大小 | 2048 |
| 注意力头 | 多头注意力（MHA） |
| FFN激活函数 | SwiGLU |
| 位置嵌入 | RoPE |
| 上下文长度 | 4K（训练），可扩展到64K |

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10 |
| transformers | 4.54.1 |
| pytorch | 2.7.1+das.opt1.dtk25042 |

推荐使用镜像:
- 挂载地址`-v`，`{docker_name}`和 `{docker_image_name}`根据实际模型情况修改

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.7.1-ubuntu22.04-dtk25.04.2-py3.10-alpha
docker run -it --shm-size 200g --network=host --name {docker_name} --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro {imageID} bash

cd /your_code_path/ouro_pytorch
pip install transformers==4.54.1
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装
## 数据集

暂无

## 训练
暂无

## 推理

### transformers
#### 单机推理
```bash
export HIP_VISIBLE_DEVICES=0
python Ouro-1.4B.py 
```

## 效果展示

<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Ouro-1.4B | 1.4B | K100AI,BW1000 | 1 | [下载地址](https://huggingface.co/ByteDance/Ouro-1.4B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/ouro_pytorch

## 参考资料
- https://huggingface.co/ByteDance/Ouro-1.4B
