# open_clip

## 论文

`Reproducible scaling laws for contrastive language-image learning`

* https://arxiv.org/pdf/2212.07143

## 模型结构

CLIP 模型有两个主要组件，一个文本编码器和一个图像编码器。对于文本编码器，使用了`Transformer`；对于图像编码器采用了`ResNet`和`Vision Transformer（ViT）`。

![alt text](readme_imgs/model.png)

## 算法原理

CLIP通过最大化`文本-图像`匹配得分同时训练一个图像编码器和文本编码器。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10

    docker run --shm-size 50g --network=host --name=clip --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install timm --no-deps

    pip install -r requirements.txt

    pip install build 

    python -m build && pip install dist/open_clip_torch-2.26.1-py3-none-any.whl


### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 50g --network=host --name=clip --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install timm --no-deps

    pip install -r requirements.txt

    pip install build 

    python -m build && pip install dist/open_clip_torch-2.26.1-py3-none-any.whl

### Anaconda (方法三)

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装：
https://developer.hpccube.com/tool/

    DTK驱动：dtk24.04.1
    python：python3.10
    torch: 2.1.0
    torchvision: 0.16.0

Tips：以上dtk驱动、python、torch等DCU相关工具版本需要严格一一对应

2、其它非特殊库参照requirements.txt安装

    pip install timm --no-deps

    pip install -r requirements.txt

    pip install build 

    python -m build && pip install dist/open_clip_torch-2.26.1-py3-none-any.whl

## 数据集

### CLIP

#### 数据下载

完整数据集下载参考[img2dataset](https://github.com/rom1504/img2dataset)。

这里提供其他数据集，可通过[SCNet高速通道下载](http://113.200.138.88:18080/aidatasets/)。

- 训练数据集：[cc3m wds](http://113.200.138.88:18080/aidatasets/pixparse/cc3m-wds)

- 验证数据集：[imagenet2012-val](http://113.200.138.88:18080/aidatasets/project-dependency/imagenet-2012/)，数据下载完成后在数据目录下运行`bash valprep.sh`对数据进行分类(将extra_utils下的`valprep.sh`移动到数据目录下)。

#### 数据处理

在准备数据集时，可以使用`img2dataset`直接下载的数据集(`.tar`)，也可自行准备数据集，自行准备的数据集可以`image_path caption`的形式并以`csv`格式保存，本项目提供了相应的脚本，位于`extra_utils/convert_to_csv.py`。

|filepath|title|
|:-------:|:-------:|
|<path/to/image>|a white cat|

注意：更多数据处理及使用方式，可参考[官方readme](README_official.md)。

### CoCa

运行`extra_utils/coca_data.py`会自动下载并处理数据。也可通过[SCNet高速下载通道](http://113.200.138.88:18080/aidatasets/project-dependency/mscoco2014)下载数据集并修改代码中`root_path`后运行该脚本处理数据。

## 训练

### CLIP

#### 单卡运行

    python -m open_clip_train.main \
    --save-frequency 1 \
    --zeroshot-frequency 1 \
    --report-to tensorboard \
    --train-data="/path/to/train_data.csv"  \
    --val-data="/path/to/validation_data.csv"  \
    --csv-img-key filepath \
    --csv-caption-key title \
    --imagenet-val=/path/to/imagenet/root/val/ \
    --warmup 10000 \
    --batch-size=128 \
    --lr=1e-3 \
    --wd=0.1 \
    --epochs=30 \
    --workers=8 \
    --model RN50 \
    --csv-separator "," \
    --precision amp_bf16 

注意：`imagenet-val`表示使用imagenet作为验证集，若不需要可以删除。

#### 多卡运行

##### 单节点

    cd open_clip/src
    torchrun --nproc_per_node 4 -m open_clip_train.main \
    --train-data '/data/cc12m/cc12m-train-{0000..2175}.tar' \
    --train-num-samples 10968539 \
    --dataset-type webdataset \
    --batch-size 320 \
    --precision amp_bf16 \
    --workers 4 \
    --imagenet-val /data/imagenet/validation/ 

##### 多节点

    cd open_clip/src
    torchrun --nproc_per_node=4 \
    --rdzv_endpoint=$HOSTE_NODE_ADDR \
    -m open_clip_train.main \
    --train-data '/data/cc12m/cc12m-train-{0000..2175}.tar' \
    --train-num-samples 10968539 \
    --dataset-type webdataset \
    --batch-size 320 \
    --precision amp_bf16 \
    --workers 4 \
    --imagenet-val /data/imagenet/validation/ \
    --precision amp_bf16 

注意：更多方式请参考[README_official.md](README_official.md)，使用`fp16`训练会导致`nan`，需要替换为`bf16`。

### CoCa

```python
python -m open_clip_train.main \
    --dataset-type "csv" \
    --train-data /path/to/your.csv \
    --warmup 1000 \
    --batch-size 32 \
    --lr 1e-5 \
    --wd 0.1 \
    --epochs 1 \
    --workers 3 \
    --model "coca_ViT-L-14" \
    --coca-contrastive-loss-weight 0 \
    --coca-caption-loss-weight 1 \
    --log-every-n-steps 100
```

## 推理

### CLIP

    # 不提供参数会使用默认参数并自动下载模型
    # export HF_ENDPOINT=https://hf-mirror.com
    python custom_tests/simple_test.py --model_name <xxx> --pretrained <可以是本地路径/path/to/open_clip_pytorch_model.bin，也可以是远程仓库名(如：laion2b_s34b_b79k)>


### CoCa

    # 可以仅输入image_path，其他使用默认参数
    # export HF_ENDPOINT=https://hf-mirror.com
    python custom_tests/coca_simple_test.py <path/to/image>

注意：可使用以下参数修改使用的模型`--model_name <xxx> --pretrained <可以是本地路径/path/to/open_clip_pytorch_model.bin，也可以是远程仓库名(如：mscoco_finetuned_laion2B-s13B-b90k)> `

## result

`python custom_test.py`

CLIP: 

|a diagram|a dog|a cat|
|:---:|:---:|:---:|
|0.995|0.004|0.001|

CoCa:

输入：<img src="readme_imgs/girl.png" style="zoom:50%;">

输出：a beautiful young woman with a long black ponytail .

### 精度

K100_AI与L20精度保持一致。

## 应用场景

### 算法类别

`图像分类`

### 热点应用行业

`电商,绘画,交通`

## 预训练权重

下载模型后放入`pretrained_models`文件夹中（需要自行创建）。

完整模型列表可通过`python -c "import open_clip; print(open_clip.list_pretrained())"`查看，这里提供常用的预训练权重链接。

|model|链接|
|:---:|:------:|
|CLIP-ViT-B-32-laion2B-s34B-b79K|[原始链接](https://huggingface.co/laion/CLIP-ViT-B-32-laion2B-s34B-b79K)/[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/CLIP-ViT-B-32-laion2B-s34B-b79K)||
|CLIP-ViT-B-16-laion2B-s34B-b88K|[原始链接](https://huggingface.co/laion/CLIP-ViT-B-16-laion2B-s34B-b88K)/[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/CLIP-ViT-B-16-laion2B-s34B-b88K)|
|CLIP-ViT-H-14-laion2B-s32B-b79K|[原始链接](https://huggingface.co/laion/CLIP-ViT-H-14-laion2B-s32B-b79K)/[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/CLIP-ViT-H-14-laion2B-s32B-b79K)|
|CLIP-ViT-bigG-14-laion2B-39B-b160k|[原始链接](https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k)/[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/CLIP-ViT-bigG-14-laion2B-39B-b160k)|
|CLIP-convnext_large_d_320.laion2B-s29B-b131K-ft-soup|[原始链接](https://huggingface.co/laion/CLIP-convnext_large_d_320.laion2B-s29B-b131K-ft-soup)/[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/CLIP-convnext_large_d_320.laion2B-s29B-b131K-ft-soup)|
|bioclip|[原始链接](https://huggingface.co/imageomics/bioclip)/[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/imageomics/bioclip)|
|mscoco_finetuned_CoCa-ViT-L-14-laion2B-s13B-b90k |[原始链接](https://hf-mirror.com/laion/mscoco_finetuned_CoCa-ViT-L-14-laion2B-s13B-b90k/tree/main)/[SCNet高速下载通道](http://113.200.138.88:18080/aimodels/mscoco_finetuned_CoCa-ViT-L-14-laion2B-s13B-b90k)|


## 源码仓库及问题反馈

* https://developer.hpccube.com/codes/modelzoo/open_clip_pytorch

## 参考资料

* https://github.com/mlfoundations/open_clip/

