#!/bin/bash

export HIP_VISIBLE_DEVICES=4

csv_path="datasets/train2014.csv"

python -m open_clip_train.main \
    --dataset-type "csv" \
    --train-data ${csv_path} \
    --warmup 1000 \
    --batch-size 32 \
    --lr 1e-5 \
    --wd 0.1 \
    --epochs 1 \
    --workers 3 \
    --model "coca_ViT-L-14" \
    --coca-contrastive-loss-weight 0 \
    --coca-caption-loss-weight 1 \
    --log-every-n-steps 100