# Web 表驱动的数据库合成

## 准备 Web 表

```bash
unzip web_tables.json.zip
```

### 第 1 步：初始数据库生成

从 Web 表生成初始数据库。

```bash
# Run 创建用于数据库生成的提示。
mkdir prompts
python3 generate_schema_synthesis_prompts.py
```

```bash
# 生成初始数据库架构。
# 此处使用vllm服务，也可以修改脚本使用其他服务
vllm serve model_name -tp 2

mkdir results
python3 synthesize_schema.py --model model_name --base_url vllm_serve_url(http://x.x.x.x:8000/v1)
```

### 第 2 步：数据库增强

增强最初生成的数据库，以提高复杂性和真实感。

```bash
## 运行 以创建数据库增强的提示
python3 generate_schema_enhancement_prompts.py
```

```bash
# 运行以生成增强的数据库架构
# vllm serve model_name -tp 2
python3 enhance_schema.py --model model_name --base_url vllm_serve_url(http://x.x.x.x:8000/v1)
```

### 第 3 步：构建 SQLite 数据库

```bash
# 运行以构建存储在文件夹中的 SQLite 数据库
python3 build_sqlite_databases.py
```

```bash
# Run 以创建文件，其中包含有关合成数据库的详细信息，与以前的文本到 SQL 数据集保持一致
python3 generate_tables_json.py
```