# OmniSQL

## 论文

`OmniSQL: Synthesizing High-quality Text-to-SQL Data at Scale`

* https://arxiv.org/pdf/2503.02240

## 模型结构
该框架分为四个关键步骤：
- 基于网页表的数据库合成：利用网络上丰富的表格数据，合成出符合现实商业场景的数据库。通过提示LLM生成与给定表格相关的数据库，包括多个关系表及其结构信息。
- 复杂度感知的SQL查询生成：根据合成的数据库生成SQL查询，LLM会根据指定的复杂度级别（简单、中等、复杂和高度复杂）生成相应的SQL查询。
- 风格化自然语言问题合成：将生成的SQL查询转换为自然语言问题，采用多种语言风格（如正式、口语、模糊等），以增强语言多样性。
- 链式推理解决方案合成：为每个合成的文本到SQL数据生成逐步的链式推理解决方案，详细说明从问题到SQL查询的推理过程，增强数据的可解释性。

![alt text](readme_imgs/arch.png)

## 算法原理

主要原理是利用大型语言模型（LLMs）和自动化预处理与后处理策略来生成高质量和多样化的数据样本，从而减少对人工干预的依赖，并使用生成的数据在现有的LLM基础上训练模型。

![alt text](readme_imgs/alg.png)

## 环境配置

### Docker（方法一）
    
    docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04-py3.10

    docker run --shm-size 500g --network=host --name=omnisql --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash

    pip install -r requirements.txt

### Dockerfile（方法二）

    docker build -t <IMAGE_NAME>:<TAG> .

    docker run --shm-size 500g --network=host --name=omnisql --privileged --device=/dev/kfd --device=/dev/dri --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -v 项目地址(绝对路径):/home/ -v /opt/hyhal:/opt/hyhal:ro -it <your IMAGE ID> bash
    
    pip install -r requirements.txt

### Anaconda（方法三）

1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/

```
dtk: 25.04
python: 3.10
torch: 2.4.1
deepspeed: 0.14.2
flash-attn: 2.6.1
vllm: 0.6.2
triton: 3.0.0
```

2、其他非特殊库直接按照requirements.txt安装

```
pip install -r requirments.txt
```

## 数据集

下载至`train_and_evaluate`并解压.

训练数据 - [hf](https://huggingface.co/datasets/seeklhy/OmniSQL-datasets/) | [modelscope](https://www.modelscope.cn/datasets/seeklhy/OmniSQL-datasetss)

测试数据 - [googledriver](https://drive.google.com/file/d/1iNa1WgA9tN_OFna08nq_tHZdXx9Lz2vO/view) 

除此之外也可以按需自行合成数据，参考`data_synthesis`.

本项目提供了用于测试训练功能的数据，位于`train_and_evaluate/data`.

## 训练

```bash
cd train_and_evaluate

# train OmniSQL-7B using SynSQL-2.5M
sh train_omnisql_7b.sh
# train OmniSQL-14B using SynSQL-2.5M
sh train_omnisql_14b.sh
# train OmniSQL-32B using SynSQL-2.5M
sh train_omnisql_32b.sh
```

注意：训练前需修改文件中的模型及数据路径（参考`train_omnisql_7b.sh`），更多设置见`accelerate_config_(7/14/32)b.yaml`

## 推理

注意：在运行推理前按需修改代码中的模型路径及prompt。

### Transformers

```bash
cd inferences

python tf_inference.py
```

### vllm

```bash
cd inferences

python vllm_inference.py
```

### vllm_serve

```bash
vllm serve /path/to/model -tp 1
```

```bash
cd inferences

bash vllm_inference.sh
```


## result

![alt text](readme_imgs/result.png)

### 精度

||loss|
|:---:|:---:|
|N卡|0.1449|
|dcu|0.1448|

epoch: 1

## 应用场景

### 算法类别

`对话问答`

### 热点应用行业

`电商,教育,广媒`

## 预训练权重

下载后的模型放在 `ckpts` 目录（自行创建）

| Model  | url |
|-----------|------------------|
| OmniSQL-7B  | [✨ Modelscope](https://modelscope.cn/models/seeklhy/OmniSQL-7B), [🤗 HuggingFace](https://huggingface.co/seeklhy/OmniSQL-7B) |
| OmniSQL-14B | [✨ Modelscope](https://modelscope.cn/models/seeklhy/OmniSQL-14B), [🤗 HuggingFace](https://huggingface.co/seeklhy/OmniSQL-14B) |
| OmniSQL-32B | [✨ Modelscope](https://modelscope.cn/models/seeklhy/OmniSQL-32B), [🤗 HuggingFace](https://huggingface.co/seeklhy/OmniSQL-32B) |


## 源码仓库及问题反馈

* https://developer.sourcefind.cn/codes/modelzoo/omnisql_pytorch

## 参考资料

* https://github.com/RUCKBReasoning/OmniSQL
