# OmniMotion
一种在视频序列中密集和长距离运动估计方法，可对运动目标逐像素跟踪。

## 论文
`Tracking Everything Everywhere All at Once`
- https://arxiv.org/abs/2306.05422
- ICCV 2023, Oral, Best Student Paper

## 模型结构
<!-- 此处一句话简要介绍模型结构 -->
先把一个序列表示成一个准3D的规范量，然后通过定义一个双射，这样就可以通过一个准3D空间，来描述一个完整的运动。
<div align=center>
    <img src="./doc/Method_overview.png"/>
</div>

## 算法原理
OmniMotion 保留了投影到每个像素的所有场景点的信息，以及它们的相对深度顺序，这让画面中的点即使暂时被遮挡，也能对其进行追踪。将一整个视频序列作为输入, 同时还输入噪声运动估计(例如光流估计), 然后解出一个完整、全局的运动轨迹。然后，添加了一个优化过程，使其可以用任何帧中的任何像素查询表征，以在整个视频中产生平滑、准确的运动轨迹。

<!-- <div align=center>
    <img src="./doc/基本原理.png"/>
</div> -->

## 环境配置
```
mv omnimotion_pytoch omnimotion # 去框架名后缀
# -v 路径、docker_name和imageID根据实际情况修改
```
### Docker（方法一）
<!-- 此处提供[光源](https://www.sourcefind.cn/#/service-details)拉取docker镜像的地址与使用步骤 -->
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:1.13.1-ubuntu20.04-dtk23.10-py38 # 本镜像imageID为：0a56ef1842a7
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /your_code_path/omnimotion
pip install -r requirements.txt

```
### Dockerfile（方法二）
<!-- 此处提供dockerfile的使用方法 -->
```
cd /your_code_path/omnimotion/docker
docker build --no-cache -t codestral:latest .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=16G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /your_code_path/omnimotion
pip install -r requirements.txt
```
### Anaconda（方法三）
<!-- 此处提供本地配置、编译的详细步骤，例如： -->

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.hpccube.com/tool/)开发者社区下载安装。
```
DTK驱动：dtk23.10
python：python3.8
pytorch:1.13.1
```
`Tips：以上DTK驱动、python、pytorch等DCU相关工具版本需要严格一一对应`

其它非深度学习库参照requirements.txt安装：
```
pip install -r requirements.txt
```
## 数据集
`DAVIS`
- https://davischallenge.org/index.html

<!-- - 此处填写公开数据集在公司内部的下载地址（数据集存放中心为：[SCNet AIDatasets](http://113.200.138.88:18080/aidatasets) ，模型用到的各公开数据集请分别填上具体地址。），过小权重文件可打包到项目里。 -->
<!-- - 此处填写公开数据集官网下载地址（非必须）。 -->

数据下载、预处理脚本的使用方法
```
cd /your_code_path/omnimotion/
python get_davis.py # 下载数据集DAVIS-2017-trainval-480p
python main_processing.py # 预处理数据集
```
训练数据目录结构如下，用于正常训练的完整数据集请按此目录结构进行制备：
```
├──DAVIS
    ├──sequence_1/
        ├──color/
        ├──mask/ (optional; only used for visualization purposes)
        ├──count_maps/
        ├──features/
        ├──raft_exhaustive/
        ├──raft_masks/
        ├──flow_stats.json
    ├──sequence_2/
    ├──...
```

## 训练
<!-- 一般情况下，ModelZoo上的项目提供单机训练的启动方法即可，单机多卡、单机单卡至少提供其一训练方法。 -->
<!-- ### 单机多卡
```
python train.py --config configs/default.txt # 注意修改configs文件以及config.py文件
``` -->

### 单机单卡
```
python train.py --config configs/default.txt # 注意修改configs文件以及config.py文件
```

## 推理
```
python viz.py --config configs/default.txt
```
## result
<!-- 此处填算法效果测试图（包括输入、输出） -->
训练loss情况，视频序列为`dogs-jump`，绿色为GPU，橘色为DCU
<div align=center>
    <img src="./doc/loss.png"/>
</div>
可视化结果

- GPU: ./doc/GPU-dogs-jump_corr_foreground_100000.mp4

<video src="./doc/GPU-dogs-jump_corr_foreground_100000.mp4" controls="controls" width="700" height="200"></video>


- DCU: ./doc/DCU-dogs-jump_corr_foreground_100000.mp4

<video src="./doc/DCU-dogs-jump_corr_foreground_100000.mp4" controls="controls" width="700" height="200"></video>

### 精度
无
<!-- 测试数据：[test data](链接)，使用的加速卡:xxx。

根据测试结果情况填写表格：
| xxx | xxx | xxx | xxx | xxx |
| :------: | :------: | :------: | :------: |:------: |
| xxx | xxx | xxx | xxx | xxx  |
| xxx | xx | xxx | xxx | xxx | -->

## 应用场景
### 算法类别
<!-- 参考此分类方法（上传时请去除参考图片），与icon图标类别一致，请勿随意命名： -->
<!-- <div align=center>
    <img src="./doc/icon.png"/>
</div> -->

<!-- 超出以上分类的类别命名也可参考此网址中的类别名：https://huggingface.co/ \ -->
`目标跟踪`

### 热点应用行业
<!-- 应用行业的填写需要做大量调研，从而为使用者提供专业、全面的推荐，除特殊算法，通常推荐数量>=3。 -->
`制造,电商,医疗,教育`

<!-- ## 预训练权重 -->
<!-- - 此处填写预训练权重在公司内部的下载地址（预训练权重存放中心为：[SCNet AIModels](http://113.200.138.88:18080/aimodels) ，模型用到的各预训练权重请分别填上具体地址。），过小权重文件可打包到项目里。
- 此处填写公开预训练权重官网下载地址（非必须）。 -->

## 源码仓库及问题反馈
<!-- - 此处填本项目gitlab地址 -->
- https://developer.hpccube.com/codes/modelzoo/omnimotion_pytorch

## 参考资料
- https://github.com/qianqianwang68/omnimotion

