# OLMo-3
## 论文
暂无

## 模型简介
我们推出了 Olmo 3，这是一个新的 7B 和 32B 模型系列，包括 Instruct 和 Think 变体。长链思维可以改进数学和编码等推理任务。

Olmo 是一系列开源语言模型，旨在推动语言模型的科学研究。 这些模型在 Dolma 3 数据集上进行了预训练，并在 Dolci 数据集上进行了后训练。我们将发布所有代码、检查点、日志（即将推出）以及相关的训练细节。

本次发布的核心模型包括以下内容：

**OLMo 3 Base：** 在 5.9T tokens 上预训练，通过独特的 Token 约束混合与质量感知上采样策略优化数据分布；引入了大规模的 olmOCR 处理后的科学 PDF 数据；并在 100B tokens 的中期训练（Midtraining）中针对代码、数学和 QA 进行了强化。
**OLMo 3 Think：** 这是 OLMo 3 的旗舰推理模型，采用了 SFT -> DPO -> RLVR（带验证奖励的强化学习）的三阶段后训练配方。报告详细披露了如何通过“Delta Learning”构建偏好数据，以及 OlmoRL 框架在算法和基础设施上的改进（如去除了 KL 散度项、引入 Token 级损失等）。
**全栈数据公开：** 发布了预训练数据 Dolma 3 Mix、中期训练数据 Dolmino Mix、长上下文数据 Longmino Mix 以及后训练数据 Dolci 系列。

| Benchmark | Olmo 3 Think 32B SFT | Olmo 3 Think 32B DPO | Olmo 3 Think 32B | Qwen 3 32B | Qwen 3 VL 32B Thinking | Qwen 2.5 32B | Gemma 3 27B Instruct | Gemma 2 27B Instruct | Olmo 2 32B Instruct | DeepSeek-R1-Distill-Qwen-32B |
|-----------|-----------------------|-----------------------|-------------------|-------------|-------------------------|---------------|------------------------|------------------------|---------------------------|---------------------------------|
| **Math** | | | | | | | | | | |
| MATH | 95.6 | 95.9 | 96.1 | 95.4 | 96.7 | 80.2 | 87.4 | 51.5 | 49.2 | 92.6 |
| AIME 2024 | 73.5 | 76.0 | 76.8 | 80.8 | 86.3 | 15.7 | 28.9 | 4.7 | 4.6 | 70.3 |
| AIME 2025 | 66.2 | 70.7 | 72.5 | 70.9 | 78.8 | 13.4 | 22.9 | 0.9 | 0.9 | 56.3 |
| OMEGA | 43.1 | 45.2 | 50.8 | 47.7 | 50.8 | 19.2 | 24.0 | 9.1 | 9.8 | 38.9 |
| **Reasoning** | | | | | | | | | | |
| BigBenchHard | 88.8 | 89.1 | 89.8 | 90.6 | 91.1 | 80.9 | 82.4 | 66.0 | 65.6 | 89.7 |
| ZebraLogic | 70.5 | 74.5 | 76.0 | 88.3 | 96.1 | 24.1 | 24.8 | 17.2 | 13.3 | 69.4 |
| AGI Eval English | 85.9 | 87.8 | 88.2 | 90.0 | 92.2 | 78.9 | 76.9 | 70.9 | 68.4 | 88.1 |
| **Coding** | | | | | | | | | | |
| HumanEvalPlus | 90.0 | 91.6 | 91.4 | 91.2 | 90.6 | 82.6 | 79.2 | 67.5 | 44.4 | 92.3 |
| MBPP+ | 66.7 | 67.2 | 68.0 | 70.6 | 66.2 | 66.6 | 65.7 | 61.2 | 49.0 | 70.1 |
| LiveCodeBench v3 | 75.8 | 81.9 | 83.5 | 90.2 | 84.8 | 49.9 | 39.0 | 28.7 | 10.6 | 79.5 |
| **IF** | | | | | | | | | | |
| IFEval | 83.9 | 80.6 | 89.0 | 86.5 | 85.5 | 81.9 | 85.4 | 62.1 | 85.8 | 78.7 |
| IFBench | 37.0 | 34.4 | 47.6 | 37.3 | 55.1 | 36.7 | 31.3 | 27.8 | 36.4 | 23.8 |
| **Knowledge & QA** | | | | | | | | | | |
| MMLU | 85.3 | 85.2 | 85.4 | 88.8 | 90.1 | 84.6 | 74.6 | 76.1 | 77.1 | 88.0 |
| PopQA | 33.1 | 37.0 | 31.9 | 30.7 | 32.2 | 28.0 | 30.2 | 30.4 | 37.2 | 26.7 |
| GPQA | 55.7 | 57.6 | 58.1 | 67.3 | 67.4 | 44.6 | 45.0 | 39.9 | 36.4 | 61.8 |
| **Chat** | | | | | | | | | | |
| AlpacaEval 2 LC | 69.1 | 78.6 | 74.2 | 75.6 | 80.9 | 81.9 | 65.5 | 39.8 | 38.0 | 26.2 |
| **Safety** | 64.8 | 65.3 | 68.8 | 69.0 | 82.7 | 81.9 | 68.6 | 74.3 | 83.8 | 63.6 |




## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name olmo-3 --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/ image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### pytorch
#### 单机推理
可参考run.sh脚本
```python 
from transformers import AutoModelForCausalLM, AutoTokenizer
olmo = AutoModelForCausalLM.from_pretrained("/path/to/allenai/Olmo-3-7B-Think")
tokenizer = AutoTokenizer.from_pretrained("/path/to/allenai/Olmo-3-7B-Think")
message = ["Language modeling is "]
inputs = tokenizer(message, return_tensors='pt', return_token_type_ids=False)
# optional verifying cuda
inputs = {k: v.to('cuda') for k,v in inputs.items()}
olmo = olmo.to('cuda')
response = olmo.generate(**inputs, max_new_tokens=2048, do_sample=True, top_k=50, top_p=0.95)
print(tokenizer.batch_decode(response, skip_special_tokens=True)[0])
```

## 效果展示
<div align=center>
    <img src="./doc/example.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：pytorch。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| Olmo-3-7B-Think | 7B | BW1000 | 1 | [下载地址](https://modelscope.cn/models/allenai/Olmo-3-7B-Think) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/olmo3_pytorch

## 参考资料
- https://github.com/allenai/OLMo
