# ModelScope

ModelScope is a new platform that provides "Model-As-A-Service", where users can use state-of-the-art models with the lowest costs of efforts as possible. We have released:
* The pretrained and finetuned **OFA** models
* **Chinese CLIP** (the CLIP pretrained Chinese data, which was previously released in our organization)
* The pretrained and finetuned **MMSpeech** models

on the platform, including the English and Chinese ones. Feel free to check these models and use them with ModelScope, and also feel free to send us feedbacks to help us improve the product.

## Chinese
* Chinese CLIP \[[Base](https://www.modelscope.cn/#/models/damo/multi-modal_clip-vit-base-patch16_zh/summary) | [Large](https://www.modelscope.cn/#/models/damo/multi-modal_clip-vit-large-patch14_zh/summary)\]
* Finetuned OFA on Visual Grounding (RefCOCO) \[[Large](https://www.modelscope.cn/#/models/damo/ofa_visual-grounding_refcoco_large_zh/summary)\]
* MMSpeech \[[Base](https://www.modelscope.cn/models/damo/ofa_mmspeech_pretrain_base_zh/summary) | [Large](https://www.modelscope.cn/models/damo/ofa_mmspeech_pretrain_large_zh/summary) \]

## English
* Finetuned OFA on Image Captioning \[[Large](https://www.modelscope.cn/#/models/damo/ofa_image-caption_coco_large_en/summary) | [Distill](https://modelscope.cn/#/models/damo/ofa_image-caption_coco_distilled_en/summary)\]
* Finetuned OFA on Text-to-Image Generation \[[Large](https://www.modelscope.cn/#/models/damo/ofa_text-to-image-synthesis_coco_large_en/summary) | [Distill](https://modelscope.cn/#/models/damo/ofa_visual-grounding_refcoco_distilled_en/summary)\]
* Finetuned OFA on Visual Question Answering \[[Large](https://www.modelscope.cn/#/models/damo/ofa_visual-question-answering_pretrain_large_en/summary)\]
* Finetuned OFA on Visual Grounding (RefCOCO) \[[Large](https://www.modelscope.cn/#/models/damo/ofa_visual-grounding_refcoco_large_en/summary)\]
* Finetuned OFA on Visual Entailment \[[Large](https://www.modelscope.cn/#/models/damo/ofa_visual-entailment_snli-ve_large_en/summary) | [Distill](https://modelscope.cn/#/models/damo/ofa_visual-entailment_snli-ve_distilled_v2_en/summary)\]
* Finetuned OFA on Summarization (Gigaword) \[[Large](https://www.modelscope.cn/#/models/damo/ofa_summarization_gigaword_large_en/summary)\]
* Finetuned OFA on Natural Language Entailment (MNLI, can be used to finetune on the GLUE benchmark) \[[Large](https://modelscope.cn/#/models/damo/ofa_text-classification_mnli_large_en/summary)\]
* Finetuned OFA on Image Classification (ImageNet-1k) \[[Large](https://modelscope.cn/#/models/damo/ofa_image-classification_imagenet_large_en/summary)\]


