# OctoMed-7B
## 论文
[OctoMed-7B](https://arxiv.org/pdf/2511.23269)
## 模型简介
OctoMed-7B是一款高性能多模态医学推理模型，通过大规模数据治理和基于监督微调（SFT）的方法构建。为支撑可靠的临床推理能力，开发了可扩展的数据处理流程，从DeepSeek-R1和GPT-4o中蒸馏出结构化推理轨迹，构建了迄今规模最大的多模态医学推理数据集，包含超过800万条推理轨迹和68亿响应token。  
OctoMed-7B以Qwen2.5-VL-7B-Instruct为基座模型，在该精炼数据集上进行训练，在多项分布外医学基准测试中均实现了优异且稳健的性能表现。OctoMed-7B在输出最终答案前，会通过<think>...</think>标记生成内部推理轨迹。通常，该模型在面对难度较高或定义不明确的问题时倾向于延长推理过程，而对于简单查询则保持较短的推理轨迹。医学基准测试性能表现如下：

<div align=center>
    <img src="./doc/perf.png"/>
</div>

## 环境依赖

| 软件 | 版本 |
| :------: | :------: |
| DTK | 25.04.2 |
| python | 3.10.12 |
| transformers | >=4.57.1 |
| vllm |  0.9.2+das.opt1.dtk25042 |
| torch | 2.5.1+das.opt1.dtk25042 |
| triton | 3.1+das.opt1.3c5d12d.dtk25041 |
| flash_attn | 2.6.1+das.opt1.dtk2504 |
| flash_mla | 1.0.0+das.opt1.dtk25042 |

当前仅支持镜像:
- 挂载地址`-v`根据实际模型情况修改

```bash
docker run -it --shm-size 60g --network=host --name OctoMed --privileged --device=/dev/kfd --device=/dev/dri --device=/dev/mkfd --group-add video --cap-add=SYS_PTRACE --security-opt seccomp=unconfined -u root -v /opt/hyhal/:/opt/hyhal/:ro -v /path/your_code_path/:/path/your_code_path/  image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.2-py3.10 bash
```
更多镜像可前往[光源](https://sourcefind.cn/#/service-list)下载使用。

关于本项目DCU显卡所需的特殊深度学习库可从[光合](https://developer.sourcefind.cn/tool/)开发者社区下载安装。

## 数据集
暂无

## 训练
暂无

## 推理

### vllm
#### 单机推理
可参考vllm_serve.sh脚本
```bash
## serve启动
vllm serve OctoMed/OctoMed-7B/    --trust-remote-code --dtype bfloat16 --max-seq-len-to-capture 32768 -tp 1   --max-model-len 32768
## client访问
可参考vllm_cilent.sh
curl -X POST "http://localhost:8000/v1/chat/completions"   -H "Content-Type: application/json"     --data '{
                "model": "OctoMed/OctoMed-7B/",
                "messages": [
                        {
                                "role": "user",
                                "content": [
                                        {
                                                "type": "text",
                                                "text": "Describe this image in one sentence."
                                        },
                                        {
                                                "type": "image_url",
                                                "image_url": {
                                                        "url": "https://img-s.msn.cn/tenant/amp/entityid/AA1S6LMz.img?w=640&h=427&m=6"
                                                }
                                        }
                                ]
                        }
                ]
        }'
```

## 效果展示
<div align=center>
    <img src="./doc/result.png"/>
</div>

### 精度
DCU与GPU精度一致，推理框架：vllm。

## 预训练权重
| 模型名称  | 权重大小  | DCU型号  | 最低卡数需求 |下载地址|
|:-----:|:----------:|:----------:|:---------------------:|:----------:|
| OctoMed-7B | 7B | K100AI | 1 | [下载地址](https://huggingface.co/OctoMed/OctoMed-7B) |

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/octomed_vllm

## 参考资料
- https://huggingface.co/OctoMed/OctoMed-7B
